/*************************************************
**  npelist.c                                   **
**  command  : clist                            **
**  function : print the estimation conditions  **
*************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

#if defined(ANSI)
extern void renpe(void);
extern void wrnpe(void);
extern void initHead(void);
void  listAllElement(void);
void  listMethod(void);
void  listLinear(void);
void  listModel(void);
void  listInit(void);
void  listScale(void);
void  listTerm(void);
void  listNumber(void);
void  listPoint(void);
void  listPenalty(void);
void  listExperiment(void);
void  listWeight(void);
void  listResult(void);
void  listHistory(void);
void  listXinteg(void);
void  listDisplay(void);
void  listNorm(void);
void  listBlock(void);

#else
extern void renpe();
extern void wrnpe();
extern void initHead();
void  listAllElement();
void  listMethod();
void  listLinear();
void  listModel();
void  listInit();
void  listScale();
void  listTerm();
void  listNumber();
void  listPoint();
void  listPenalty();
void  listExperiment();
void  listWeight();
void  listResult();
void  listHistory();
void  listXinteg();
void  listDisplay();
void  listNorm();
void  listBlock();

#endif

/******************** MAIN ********************/
int main(void)
{
  int  getElmntType(char *), i;
  char    *param_c, body[MAXLINE];

  renpe();
  read_syscom();
  if(GetArgType(0) != '\0'){
    param_c = GetString(0);
    for(i=0; i<strlen(param_c); i++)
      body[i] = tolower(param_c[i]);
    body[strlen(param_c)] = '\0';
    param_c = body;
  } else {
    param_c = NULL;
  }

  switch(getElmntType( param_c )){
    case METHOD    : listMethod();  break;
    case LSEARCH   : listLinear();  break;
    case MODEL     : listModel();   break;
    case PENALTY   : listPenalty(); break;
    case INIT      : listInit();    break;
    case SCALE     : listScale();   break;
    case TERM      : listTerm();    break;
    case NUMBER    : listNumber();  break;
    case POINT     : listPoint();   break;
    case DATA      : listExperiment(); break;
    case WEIGHT    : listWeight();  break;
    case RESULT    : listResult();  break;
    case HISTORY   : listHistory(); break;  
    case XINTEG    : listXinteg();  break;
    case DISPLAY   : listDisplay(); break;
    case NORM      : listNorm();    break;
    case BLOCK     : listBlock();   break;
    default        : listAllElement(); break;
  }
  initHead();
  return( 0 );
}


void  listAllElement(void)
{
 
  listMethod();
  listLinear();
  listModel();
  listPenalty();
  listInit();
  listScale();
  listTerm();
  listNumber();
  listPoint();
  listExperiment();
  listWeight();
  listResult();
  listHistory();
  listXinteg();
  listDisplay();
  listNorm();
  listBlock();
}


void listMethod(void)
{
  if( MethodHead == NULL ) return;

  printf("\n");
  printf( "method\t: %-15s\n", MethodHead->fname );
}


void listLinear(void)
{
  if( LsearchHead == NULL ) return;

  printf("\n");
  printf( "lsearch\t: %-15s %-13.5g\n", 
         LsearchHead->fname, LsearchHead->value );
}


void listModel(void)
{
  if( ModelHead == NULL ) return;

  printf( "\n" );

  printf( "model\t:" );
  switch( ModelHead->type ){
    case USR     :
      printf(" USR     %-15s\n", ModelHead->inform.Usr.fname );
      break;
    case NCS     :
      printf( " NCS     %-15s\n", ModelHead->inform.Ncs.fname );
      break;
    default      : puts( "     Unkown type\n" );
  }
}


void  listInit(void)
{
  int    i;
  struct estparam *work2;

  if( InitHead == NULL ) return;

  printf( "\n" );

  printf( "init\t: Number of Parameter = %d\n", InitHead->paramnum );
  i = 1;
  for( work2 = InitHead->EstParam ; work2 != NULL ; work2 = work2->next ){
    printf( "   %2d : %9.5g", i, work2->value );
    if( work2->flag == FIX ){
      printf( "\tFixed   " );
    } else {
      printf( "\tVariable" );
    }
    printf( " %15s\t%9.5g", work2->name, work2->span );
    i++;
    printf( "\n" );
  }
}


void  listScale(void)
{
  if( ScaleHead == NULL ) return;

  printf( "\n" );

  printf( "scale\t: %d\n", ScaleHead->scalemethod );
}


void  listTerm(void)
{
  struct termcrite *work2;

  if( TermHead == NULL ) return;

  printf( "\n" );

  printf( "term\t: %s\n", TermHead->logic );

  for( work2 = TermHead->TermCrite ; work2 != NULL ; work2 = work2->next ){
    printf( "\t TERM%2d = %-13.5g\n", work2->critenum, work2->critevalue );
  }
}


void  listNumber(void)
{
 if( NumberHead == NULL ) return;

  printf( "\n" );

  printf( "number\t: %4d\n", NumberHead->numwave );
}


void  listPoint(void)
{
  if( PointHead == NULL ) return;

  printf( "\n" );

  printf( "point\t: %4d\n", PointHead->datapoint );
}


void  listPenalty(void)
{

  if( PenaltyHead == NULL ) return;

  printf( "\n" );
  printf( "penalty\t: %-15s\n", PenaltyHead->fname  );
  fflush(stdout);
}


void  listExperiment(void)
{
  if( ExperimentHead == NULL ) return;

  printf( "\n" );
  printf( "data\t: %-15s\n", ExperimentHead->fname );
}


void  listWeight(void)
{
  if( WeightHead == NULL ) return;

  printf( "\n" );
  printf( "weight\t: %-15s\n", WeightHead->fname );
}


void  listResult(void)
{
  if( ResultHead == NULL ) return;

  printf( "\n" );
  printf( "result\t: %-15s\n", ResultHead->fname );
}


void  listHistory(void)
{
  if( HistoryHead == NULL ) return;

  printf( "\n" );

  printf( "history\t: %-15s, (interval = %d)\n",
           HistoryHead->fname, HistoryHead->storeinterval );
}


void  listXinteg(void)
{
  if( XintegHead == NULL ) return;

  printf( "\n" );

  switch( XintegHead->integmethod ){
    case 'R' : 
      printf( "integ\t: RKG" );
      break;
    case 'E' : 
      printf( "integ\t: EULER" );
      break;
    case 'A' : 
      printf( "integ\t: ADAMS" );
      break;
    case 'F' : 
      printf( "integ\t: ADAPTIVE" );
      break;
    default :
      printf("Unknown type");
  }
  printf("\n");
}


void  listDisplay(void)
{
  if( DisplayHead == NULL ) return;

  printf("\n");

  printf("display\t: ");
  if( DisplayHead->type == NO_WEIGHT )
    printf("no weight\n");
  else
    printf("with weight\n");
}


void  listNorm(void)
{
  if( NormHead == NULL ) return;

  printf("\n");

  printf("norm\t: ");
  switch( NormHead->type ){
    case NORM_ONE :  printf("1\n");     break;
    case NORM_TWO :  printf("2\n");     break;
    case NORM_INF :  printf("infty\n"); break;
    default : printf("unknown type\n");
  }
}


void  listBlock(void)
{
  struct element  *work2;

  if( BlockHead == NULL ) return;

  printf( "\n" );
  printf( "#set\n" );

  for( work2 = BlockHead->Element; work2 != NULL; work2 = work2->next ){
    switch( work2->type ){
      case METHOD :
        printf( " method      : %d\n", work2->num );
        break;
      case LSEARCH :
        printf( " lsearch     : %d\n", work2->num );
        break;
      case MODEL :
        printf( " model       : %d\n", work2->num );
        break;
      case PENALTY :
        printf( " penalty     : %d\n", work2->num );
        break;
      case INIT :
        printf( " init        : %d\n", work2->num );
        break;
      case SCALE :
        printf( " scale       : %d\n", work2->num );
        break;
      case TERM :
        printf( " term        : %d\n", work2->num );
        break;
      case NUMBER :
        printf( " number      : %d\n", work2->num );
        break;
      case POINT :
        printf( " point       : %d\n", work2->num );
        break;
      case DATA :
        printf( " data        : %d\n", work2->num );
        break;
      case WEIGHT :
        printf( " weight      : %d\n", work2->num );
        break;
      case RESULT :
        printf( " result      : %d\n", work2->num );
        break;
      case HISTORY :
        printf( " history     : %d\n", work2->num );
        break;
      case XINTEG :
        printf( " xinteg      : %d\n", work2->num );
        break;
      case DISPLAY :
        printf( " display     : %d\n", work2->num );
        break;
      case NORM :
        printf( " norm        : %d\n", work2->num );
        break;
      default      : break;
    }
  }
}


#if !defined(EL_TYPE_MDL)
#define  EL_TYPE_MDL  3
#endif

int  getElmntType(char *cp )
{
  if(cp == NULL) return(-1);
  if(strncmp(cp,"data",EL_TYPE_MDL)==0)    return( DATA );
  if(strncmp(cp,"display",EL_TYPE_MDL)==0) return( DISPLAY );
  if(strncmp(cp,"history",EL_TYPE_MDL)==0) return( HISTORY );
  if(strncmp(cp,"init",EL_TYPE_MDL)==0)    return( INIT );
  if(strncmp(cp,"integ",EL_TYPE_MDL)==0)   return( XINTEG );
  if(strncmp(cp,"lsearch",EL_TYPE_MDL)==0) return( LSEARCH );
  if(strncmp(cp,"method",EL_TYPE_MDL)==0)  return( METHOD );
  if(strncmp(cp,"model",EL_TYPE_MDL)==0)   return( MODEL );
  if(strncmp(cp,"norm",EL_TYPE_MDL)==0)    return( NORM );
  if(strncmp(cp,"number",EL_TYPE_MDL)==0)  return( NUMBER );
  if(strncmp(cp,"penalty",EL_TYPE_MDL)==0) return( PENALTY );
  if(strncmp(cp,"point",EL_TYPE_MDL)==0)   return( POINT );
  if(strncmp(cp,"result",EL_TYPE_MDL)==0)  return( RESULT );
  if(strncmp(cp,"set",EL_TYPE_MDL)==0)     return( BLOCK );
  if(strncmp(cp,"scale",EL_TYPE_MDL)==0)   return( SCALE );
  if(strncmp(cp,"term",EL_TYPE_MDL)==0)    return( TERM );
  if(strncmp(cp,"weight",EL_TYPE_MDL)==0)  return( WEIGHT );
  return( -1 );
}

/* --- end of neplist.c ----- */
