/**************************************************
**  setdata.c                                    **
**  command  : cdata                             **
**  function : set the data file for estimation  **
**  argument : 1.data file name                  **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

/* functions which is defined in common1.c common2.c */
extern  void  renpe();
extern  void  wrnpe();
extern  void  initHead();
extern  char  *strcopy();

/* function which is defined in checkinp.c */
extern  int  checkInp();

/******************** MAIN ********************/
int  main()
{
  char   *fname;
  Experiment  *work;
  FILE   *fopen();


  renpe();
  read_syscom();
  fname  = strcopy( GetString(0) );

  if( checkInp(fname)==-1 ) exit(52);

  /*------------------------------*/
  /*      set contents            */
  /*------------------------------*/
  if(ExperimentHead == NULL){
    if( (work=(Experiment *)malloc(sizeof(Experiment))) == NULL ) {
      exit(1);
    }
    ExperimentHead = work;
    ExperimentHead->next = NULL;
  }
  ExperimentHead->fname = fname;

  wrnpe();
  initHead();
  return 0;
}
