/****************************************
**  sethistory.c                       **
**  command  : cdata                   **
**  function : set save condition      **
**  argument : 1.file name             **
**             2.record interval       **
****************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

#if defined(ANSI)
extern  void  renpe(void);
extern  void  wrnpe(void);
extern  void  initHead(void);
extern  char  *strcopy(char *s);

#else
extern  void  renpe();
extern  void  wrnpe();
extern  void  initHead();
extern  char  *strcopy();

#endif  /* ANSI */

/******************** MAIN ********************/
int main()
{
  int  interval;
  char *fname;
  History  *work;


  renpe();
  fname     = strcopy( GetString(0) ); /* file name */
  interval  = GetScalar(1);            /* interval */
  if(HistoryHead == NULL){
    if( (work=(History *)malloc(sizeof(History))) == NULL ) {
      exit(1);
    }
    HistoryHead = work;
    HistoryHead->next = NULL;
  } else {
    free(HistoryHead->fname);
  }
  HistoryHead->fname = fname;
  HistoryHead->storeinterval = interval;

  wrnpe();
  initHead();
  return(0);
}

/* ---- end of sethistory.c ----- */
