/*********************************************************
**  setinit.c                                           **
**  command  : cinit                                    **
**  function : set the initial value of each parameter  **
**  argument : 1.number of parameter                    **
**             2.initial value                          **
**             3.parameter flag (variable or fix)       **
**             4.parameter name                         **
**             5.span                                   **
*********************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <ctype.h>
#include  <strings.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

#if defined(ANSI)
/* common1.c common2.c */
extern void  renpe(void);
extern void  wrnpe(void);
extern void  initHead(void);

void  del_EstParam( struct estparam  *work2 );
void  mallocEstParam( Init *work, int num );
void  deleteEstParam(Init *work );

#else
extern void  renpe();
extern void  wrnpe();
extern void  initHead();

void  del_EstParam();
void  mallocEstParam();
void  deleteEstParam();

#endif
/******************** MAIN ********************/
int main(void)
{
  int    i, ulimit;
  char   line[MAXLINE], *cp;
  Init    *work;
  struct estparam  *work2;
  FILE    *fp, *fopen();
  int    ninit, inum;
  char   *flagt, *pnamet;
  char    flag[MAXLINE];
  char    pname[MAXPARAMNAME];
  double  val,span;

  renpe();
  read_syscom();

  ninit    = (int)GetScalar(0);
  inum     = (int)GetScalar(1);
  val      = GetScalar(2);
  flagt    = GetString(3);
  pnamet   = GetString(4);
  if( (pnamet == NULL ) || ( flagt == NULL )){
    printf("Error: Flag or Param name is wrong\n");
    exit(1);
  }
  span  = GetScalar(5);

  if( ninit<=0 ) exit(56);
  if( (inum > ninit)||(inum < 1)) exit(56);
  if( flagt != NULL ){
    for(i=0;i<strlen(flagt);i++)
      flag[i] = tolower(flagt[i]);
    flag[strlen(flagt)] = '\0';
  } else {
    strncpy("var",flag, MAXLINE);
  }
  if( pnamet != NULL ){
    strncpy( pname, pnamet, MAXPARAMNAME);
  } else {
    pname[0] = '\0';
  }

  /*------------------------------*/
  /*    check parameter number    */
  /*------------------------------*/

  if((fp = fopen( LIMITFILE, "r" )) == NULL){
    exit(401);
  }
  for( i = 0 ; i < 1 ; i++ ){
    cp=fgets( line, MAXLINE, fp );
  }
  SKIP(cp);
  sscanf( cp, "%d", &ulimit);
  if( ninit >= ulimit ){
    exit(56);
  }
  fclose( fp );
/*------------------------------*/
/*      set contents            */
/*------------------------------*/

  if( InitHead != NULL){
    if( InitHead->paramnum != ninit ){
      deleteEstParam( InitHead );

      mallocEstParam( InitHead, ninit );
    }
  } else {

    if( (work=(Init *)malloc(sizeof(Init))) == NULL ) {
        exit(1);
    }

    InitHead = work;
    InitHead->next = NULL;
    mallocEstParam( InitHead, ninit );
  }

  /* move to the target parameter */
  work2=InitHead->EstParam;
  for( i = 0 ; i < inum-1 ; i++ )
     work2=work2->next;

  work2->value = val;

  if( (strncmp(flag, "fix",strlen("fix")) == 0)){
    work2->flag = FIX;
  } else {
    work2->flag = VAR;
  } /* end if */

  strncpy( work2->name, pname , MAXPARAMNAME);

  work2->span = span;

  wrnpe();
  initHead();
  return( 0 );
}


void  mallocEstParam( work, num )
Init  *work;
int  num;
{
  int    i;
  struct estparam  *cell, *tail = NULL;

  work->paramnum = num;
  for( i = 0 ; i < work->paramnum ; i++ ){
    if( (cell=(struct estparam *)malloc(sizeof(struct estparam)))==NULL ){
      exit(1);
    }
    cell->name[0] = 'N';
    cell->name[1] = '\0';
    cell->next = NULL;
    cell->value = 0.0;
    cell->span = 1.0;

    if(i==0){
      tail = cell;
      work->EstParam = tail;
    } else {
      tail->next = cell;
      tail = tail->next; /* == tail = cell */
    }
  }
}

void  deleteEstParam( work )
Init  *work;
{

  struct estparam  *work2;

  work2=work->EstParam;
  del_EstParam( work2 );
  work->EstParam = NULL;
}


void  del_EstParam( work2 )
struct estparam  *work2;
{

  if( work2->next!=NULL )
    del_EstParam( work2->next );
  else{
    free( work2 );
  }
}
