/**************************************************
**  setlinear.c                                  **
**  command  : clsearch                          **
**  function : set linear search method          **
**  argument : 1.linear search method            **
**             2.search parameter                **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

#if defined(ANSI)
extern  void  renpe(void);
extern  void  wrnpe(void);
extern  void  initHead(void);
extern  char  *strcopy(char *s);

#else
extern  void  renpe();
extern  void  wrnpe();
extern  void  initHead();
extern  char  *strcopy();

#endif /* ANSI */

/******************** MAIN ********************/
int  main()
{
  char    line[MAXLINE], str[30], *cp;
  double  value;
  char  *fname;
  Lsearch    *work;
  FILE    *fp;

  renpe();
  read_syscom();

  fname = strcopy( GetString(0) );
  value = GetScalar(1);

  /*------------------------------*/
  /*      method check            */
  /*------------------------------*/

  if( (fp = fopen( LSEARCHFILE, "r" )) == NULL )
    exit(402);

  while(1){
    if( (cp=fgets( line, MAXLINE, fp )) ==NULL ){
      exit(53);
    }
    SKIP(cp);
    sscanf( cp, "%s", str);
     if( strcmp( str, fname ) == 0 ) break;
   }

  /*------------------------------*/
  /*      set contents            */
  /*------------------------------*/

  if( LsearchHead == NULL ) {
    if( (work=(Lsearch *)malloc(sizeof(Lsearch))) == NULL ) {
      exit(1);
    }
    LsearchHead = work;
  } else {
    free(LsearchHead->fname);
  }
  LsearchHead->fname = fname;
  LsearchHead->value = value;
  LsearchHead->next = NULL;

  wrnpe();
  initHead();
  return(0);
}

/* ---- end of setlinear.c ---- */
