/**************************************************
**  setmethod.c                                  **
**  command  : cmethod                           **
**  function : set the method for estimation     **
**  argument : 1.estimation method               **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

#if defined(ANSI)
extern  void  renpe(void);
extern  void  wrnpe(void);
extern  void  initHead(void);
extern  char  *strcopy(char *s);

#else
extern  void  renpe();
extern  void  wrnpe();
extern  void  initHead();
extern  char  *strcopy();

#endif /* ANSI */

/******************** MAIN ********************/
int main()
{
  char  *cp, line[MAXLINE], str[30];
  char  *fname;
  Method  *work;
  FILE  *fp, *fopen();

  renpe();
  read_syscom();
  fname = strcopy( GetString(0) );

/*------------------------------*/
/*	method check		*/
/*------------------------------*/

  
  if((fp = fopen( METHODFILE, "r" )) == NULL )
    exit(403);

  while(1){
    if( (cp=fgets( line, MAXLINE, fp )) ==NULL ){
      exit(51);
    }
    SKIP(cp);
    sscanf( cp, "%s", str);
    if( strcmp( str, fname ) == 0 )  break;
  }
  fclose( fp );

/*------------------------------*/
/*	set contents		*/
/*------------------------------*/
	
  if( MethodHead == NULL ) {
    if( (work=(Method *)malloc(sizeof(Method))) == NULL ) {
      exit(1);
    }
    MethodHead = work;
  } else {
    free(MethodHead->fname);
  }

  MethodHead->fname = fname;
  MethodHead->next = NULL;

  wrnpe();
  initHead();
  return(0);
}

