/**************************************************
**  setmodel.c                                   **
**  command  : cmodel                            **
**  function : set model (C or NCS)              **
**  argument : 1.model type (USR or NCS) USR=C   **
**             2.model name                      **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include "global_vars.h"

#if defined(ANSI)
extern void renpe(void);
extern void wrnpe(void);
extern void initHead(void);
extern char *strcopy(char *s);
int  getModelType(char *cp);

#if !defined(Model_Type_MDL)
#define  Model_Type_MDL 3
#endif

int  getModelType( char *cp )
{
  if(strncmp(cp,"usr", Model_Type_MDL)==0) return(USR);
  if(strncmp(cp,"ncs", Model_Type_MDL)==0) return(NCS);
  return(-1);
}

#else
extern void renpe();
extern void wrnpe();
extern void initHead();
extern char *strcopy();
int  getModelType();


int  getModelType( cp )
char  *cp;
{
  if(strncmp(cp,"usr",strlen("usr"))==0) return(USR);
  if(strncmp(cp,"ncs",strlen("ncs"))==0) return(NCS);
  return(-1);
}

#endif /* ANSI */


/******************** MAIN ********************/
int  main()
{
  int  Model_Type, i, length;
  char *Model_Type_Str, Model_Type_Str_Body[MAXLINE];
  char *fname;
  Model  *work;

  renpe();
  read_syscom();

  Model_Type_Str = GetString(0);
  strncpy(Model_Type_Str_Body, Model_Type_Str, MAXLINE);
  length = strlen(Model_Type_Str);
  for(i=0;i<length;i++)
    Model_Type_Str_Body[i] = tolower(Model_Type_Str[i]);
  Model_Type_Str_Body[length] = '\0';

  fname = strcopy( GetString(1) );

  if( (Model_Type = getModelType(Model_Type_Str_Body)) == -1 )
    exit(54);

  /*----------------------*/
  /*  set contents        */
  /*----------------------*/

  if( ModelHead == NULL ) {
    if( (work=(Model *)malloc(sizeof(Model))) == NULL ) {
      exit(1);
    }
    ModelHead = work;
    ModelHead->next = NULL;
  } 

  fflush(stdout);
  fflush(stderr);

  ModelHead->type = Model_Type;

  switch( Model_Type ){
    case USR :
      ModelHead->inform.Usr.fname = fname;
      break;
    case NCS :
      ModelHead->inform.Ncs.fname = fname;
      break;
    default :
      exit(54);
  }

  wrnpe();
  initHead();
  return(0);
}

/* ---- end of setmodel.c ---- */
