/**************************************************
**  setnorm.c                                    **
**  command  : cnorm                             **
**  function : set the cal. method of norm       **
**  argument : 1.norm type                       **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"


#if defined(ANSI)
extern void renpe(void);
extern void wrnpe(void);
extern void initHead(void);

#else
extern void renpe();
extern void wrnpe();
extern void initHead();

#endif  /* ANSI */

/******************** MAIN ********************/
int  main()
{
  int    type;
  Norm  *work;

  renpe();
  read_syscom();
  type = (int)GetScalar(0);

/* --- allocation & set scaling number ---- */

  if( NormHead == NULL ) {
    if( (work=(Norm *)malloc(sizeof(Norm))) == NULL ) {
      exit(1);
    }
    NormHead = work;
  }

  NormHead->type = type;

  wrnpe();
  initHead();
  return(0);
}

/* --- end of setnorm.c --- */
