/**************************************************
**  setnumber.c                                  **
**  command  : cnumber                           **
**  function : set output number of the model    **
**  argument : 1.output number                   **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include "global_vars.h"


#if defined(ANSI)
extern  void  renpe(void);
extern  void  wrnpe(void);
extern  void  initHead(void);

#else
extern  void  renpe();
extern  void  wrnpe();
extern  void  initHead();

#endif /* ANSI */


/******************** MAIN ********************/
int  main()
{
  int     number;
  int     i, ulimit;
  char    line[MAXLINE], *cp;
  Number  *work;
  FILE    *fp, *fopen();


  renpe();
  read_syscom();
  number = (int)GetScalar(0);

  /*------------------------------*/
  /*      number check            */
  /*------------------------------*/

  if( (fp = fopen( LIMITFILE, "r" )) == NULL )
    exit(401);

  for( i = 0 ; i < 2 ; i++ ) cp=fgets( line, MAXLINE, fp );
  SKIP(cp);
  sscanf( cp, "%d", &ulimit);
  if( number > ulimit ){
    exit(61);
  }
  fclose( fp );

  /*------------------------------*/
  /*      set contents            */
  /*------------------------------*/
  if( NumberHead == NULL ) {
    if( (work=(Number *)malloc(sizeof(Number))) == NULL ) {
      exit(1);
    }
    NumberHead = work;
    NumberHead->next = NULL;
  }

  NumberHead->numwave = number;

  wrnpe();
  initHead();
  return(0);
}

/* ---- end of setnumber.c ---- */
