/**************************************************
**  setpoint.c                                   **
**  command  : cpoint                            **
**  function : set data point                    **
**  argument : 1.data point                      **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include "global_vars.h"

#if defined(ANSI)
extern  void  renpe(void);
extern  void  wrnpe(void);
extern  void  initHead(void);

#else
extern  void  renpe();
extern  void  wrnpe();
extern  void  initHead();

#endif /* ANSI */

/******************** MAIN ********************/
int  main()
{
  int    point;
  int    i, ulimit;
  char   line[MAXLINE], *cp;
  Point  *work;
  FILE   *fp, *fopen();

  renpe();
  read_syscom();
  point = (int)GetScalar(0);

  if(point < 0 ) exit(62);

  /*------------------------------*/
  /*      number check            */
  /*------------------------------*/

  
  if((fp = fopen( LIMITFILE, "r" )) == NULL)
    exit(401);

  for( i = 0 ; i < 3 ; i++ ) cp=fgets( line, MAXLINE, fp );

  SKIP(cp);
  sscanf( cp, "%d", &ulimit);
  if( point > ulimit ){
    exit(62);
  }
  fclose( fp );

  /*------------------------------*/
  /*      set contents            */
  /*------------------------------*/

  if( PointHead == NULL ) {
    if( (work=(Point *)malloc(sizeof(Point))) == NULL ) {
      exit(1);
    }
    PointHead = work;
    PointHead->next = NULL;
  }

  PointHead->datapoint = point;

  wrnpe();
  initHead();
  return(0);
}

/* ---- end of setpoint.c ---- */
