/***************************************************
**  setresult.c                                   **
**  command  : cresult                            **
**  function : set the file name to store result  **
**  argument : 1.result file name                 **
**             2.store interval                   **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

#if defined(ANSI)
extern void renpe(void);
extern void wrnpe(void);
extern void initHead(void);
extern char *strcopy(char *s);

#else
extern void renpe();
extern void wrnpe();
extern void initHead();
extern char *strcopy();

#endif  /* ANSI */

/******************** MAIN ********************/
int  main()
{
  int	interval;
  char	*fname;
  Result  *work;

  renpe();
  read_syscom();

  fname    = strcopy( GetString(0) );

  if(GetArgType(2) != '\0'){
    interval = (int)GetScalar(1);
  } else {
    interval = 1;
  }

/*----------------------*/
/*	set contents	*/
/*----------------------*/

  if(ResultHead == NULL){
    if((work=(Result *)malloc(sizeof(Result))) == NULL) {
      exit(1);
    }
    ResultHead = work;
    ResultHead->next = NULL;
  } else {
    free(ResultHead->fname);
  }

  ResultHead->fname = fname;
  ResultHead->storeinterval = interval;

  wrnpe();
  initHead();
  return(0);
}
