/**************************************************
**  setscale.c                                   **
**  command  : cscale                            **
**  function : set the scaling method            **
**  argument : 1.scaling method                  **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include "global_vars.h"

#if defined(ANSI)
extern void renpe(void);
extern void wrnpe(void);
extern void initHead(void);

#else
extern void renpe();
extern void wrnpe();
extern void initHead();

#endif  /* ANSI */

/******************** MAIN ********************/
int  main()
{
  int    scale, tnum;
  char   line[MAXLINE], *cp;
  Scale  *work;
  FILE   *fp, *fopen();

  renpe();
  read_syscom();
  scale = (int)GetScalar(0);

  if( scale<0 ) exit(58);

  /*------------------------------*/
  /*      scaling number check    */
  /*------------------------------*/

  fp = fopen( SCALEFILE, "r" );
  if( fp==NULL )
    exit(404);
  while(1){
    if( (cp=fgets( line, MAXLINE, fp )) ==NULL ){
      exit(58);
    }
    SKIP(cp);
    sscanf( cp, "%d", &tnum);
    if( scale == tnum ){
      break;
    }
  }

/* --- allocation & set scaling number ---- */

  if( ScaleHead == NULL ) {
    if( (work=(Scale *)malloc(sizeof(Scale))) == NULL ) {
      exit(1);
    }
    ScaleHead = work;
    ScaleHead->next = NULL;
  }

  ScaleHead->scalemethod = scale;

  wrnpe();
  initHead();
  return(0);
}

/* --- end of setscale.c --- */
