/**************************************************
**  setterm.c                                    **
**  command  : cterm                             **
**  function : set the term for estimation       **
**  argument : 1.term number                     **
**             2.term value                      **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <ctype.h>
#include  <string.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include "global_vars.h"


#if defined(ANSI)
extern void renpe(void);
extern void wrnpe(void);
extern void initHead(void);
void  mallocCrite(Term *head, int num, double value);

void  mallocCrite(Term *head, int num, double value)
{
  struct termcrite  *tail, *work;

  if( head == NULL ) return ;

  for( work = head->TermCrite ; work != NULL ; work = work->next )
    if( work->critenum == num ) break;

  if(work == NULL){
    if( (work=(struct termcrite *)malloc(sizeof(struct termcrite)))==NULL)
      exit(1);
    work->next = NULL;
    if(head->TermCrite == NULL){
      head->TermCrite = work;
    } else {
      for(tail = head->TermCrite; tail->next != NULL; tail = tail->next) ;
      tail->next = work;
    }
  }
  work->critenum = num;
  work->critevalue = value;
}

#else
extern void renpe();
extern void wrnpe();
extern void initHead();
void  mallocCrite();

void  mallocCrite(head, num, value)
Term *head;
int num;
double value;
{
  struct termcrite  *tail, *work;

  if( head == NULL ) return ;
  for( work = head->TermCrite ; work != NULL ; work = work->next )
    if( work->critenum == num ) break;

  if(work == NULL){
    if( (work=(struct termcrite *)malloc(sizeof(struct termcrite)))==NULL)
      exit(1);
    work->next = NULL;
    if(head->TermCrite == NULL){
      head->TermCrite = work;
    } else {
      for(tail = head->TermCrite; tail->next != NULL; tail = tail->next) ;
      tail->next = work;
    }
  }
  work->critenum = num;
  work->critevalue = value;
}

#endif  /* ANSI */

/******************** MAIN ********************/
int  main()
{
  int     termnum;
  int     tnum;
  double  value;
  char    line[MAXLINE], *cp;
  Term    *work;
  FILE    *fp, *fopen();

  renpe();
  read_syscom();

  if(strncmp(GetArgType(1),"scalar",strlen("scalar"))==0)
    termnum = (int)GetScalar(0);
  else
    termnum = atoi(GetString(0));

  value = GetScalar(1);

  /*------------------------------*/
  /*      term number check       */
  /*------------------------------*/

  if((fp = fopen( TERMFILE, "r" ))==NULL)
     exit(405);

  while(1){
    if( (cp=fgets( line, MAXLINE, fp )) ==NULL ){
      exit(59);
    }
    SKIP(cp);
    sscanf( cp, "%d", &tnum);
    if( termnum == tnum ){
      break;
    }
  }

  /*----------------------*/
  /*      set contents   */
  /*----------------------*/

  if( TermHead == NULL ) {
    if( (work=(Term *)malloc(sizeof(Term))) == NULL ) {
     exit(1);
    }
    TermHead = work;
    TermHead->next = NULL;
    TermHead->TermCrite = NULL;
    TermHead->logic = NULL;
  }
  mallocCrite( TermHead, termnum , value );
  wrnpe();
  initHead();
  return(0);
}

/* End of setterm.c */
