/**************************************************
**  setweight.c                                  **
**  command  : cweight                           **
**  function : set the weight data file          **
**  argument : 1.weight data file name           **
**************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

#if defined(ANSI)
extern void initHead(void);
extern void renpe(void);
extern void wrnpe(void);
extern char *strcopy(char *s);

#else
extern void initHead();
extern void renpe();
extern void wrnpe();
extern char *strcopy();

#endif  /* ANSI */


/******************** MAIN ********************/
int  main()
{
  char     *fname;
  int      i, ulimit;
  char     line[MAXLINE], *cp;
  Weightt  *work;
  FILE     *fp, *fopen();


  renpe();
  read_syscom();

  fname = strcopy( GetString(0) );

  /*------------------------------*/
  /*      number check            */
  /*------------------------------*/

  
  if( (fp = fopen( LIMITFILE, "r" )) == NULL )
    exit(401);

  for( i = 0 ; i < 4 ; i++ ) cp=fgets( line, MAXLINE, fp );
  SKIP(cp);
  sscanf( cp, "%d", &ulimit);
  fclose( fp );

  /*------------------------------*/
  /*      set contents            */
  /*------------------------------*/

  if( WeightHead == NULL ) {
    if( (work=(Weightt *)malloc(sizeof(Weightt))) == NULL ) {
      exit(1);
    }
    WeightHead = work;
    WeightHead->next = NULL;
  } else {
    free(WeightHead->fname);
  }

  WeightHead->fname = fname;

  wrnpe();
  initHead();
  return(0);
}
