/*********************************************************
**  setdata.c                                           **
**  command  : cdata                                    **
**  function : set the integration method of NCS model  **
**  argument : 1.integration method                     **
*********************************************************/

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>
#include  "SL_macro.h"
#include  "SL_cmd.h"
#include  "NPEcmd.h"
#include  "global_vars.h"

#if defined(ANSI)
extern  void  renpe(void);
extern  void  wrnpe(void);
extern  void  initHead(void);
int  getIntegMethod(char  *cp );

int  getIntegMethod(char  *cp )
{
  char c;

  c = tolower(*cp);
  if( c == 'r') return(1); /* Runge-Kutta method */
  if( c == 'e') return(2); /* Euler method       */
  if( c == 'a') return(3); /* ADAMS method       */
  if( c == 'f') return(4); /* ADAPTIVE method    */
  return(-1);
}

#else
extern  void  renpe();
extern  void  wrnpe();
extern  void  initHead();
int  getIntegMethod();



int  getIntegMethod( cp )
char  *cp;
{
  char c;

  c = tolower(*cp);
  if( c == 'r') return(1); /* Runge-Kutta method */
  if( c == 'e') return(2); /* Euler method       */
  if( c == 'a') return(3); /* ADAMS method       */
  if( c == 'f') return(4); /* ADAPTIVE method    */
  return(-1);
}

#endif  /* ANSI */

/******************** MAIN ********************/
int main()
{
  int  Integ_Type_int;
  char  *Integ_Type_Str;
  Xinteg  *work;


  renpe();
  read_syscom();  
  Integ_Type_Str = GetString(0);

  /*----------------------*/
  /*     set contents     */
  /*----------------------*/

  Integ_Type_int = getIntegMethod( Integ_Type_Str );

  if( XintegHead == NULL ) {
    if( (work=(Xinteg *)malloc(sizeof(Xinteg))) == NULL ) {
      exit(1);
    }
    XintegHead = work;
    XintegHead->next = NULL;
  }

  switch( Integ_Type_int ){
    case 1 :
      XintegHead->integmethod = 'R';
      break;
    case 2 :
      XintegHead->integmethod = 'E';
      break;
    case 3 :
      XintegHead->integmethod = 'A';
      break;
    case 4 :
      XintegHead->integmethod = 'F';
      break;
    default:
      XintegHead->integmethod = 'E';
  }

  wrnpe();
  initHead();
  return(0);
}

