/**************************************************
**  LIB.h                                        **
**  Header file for NPE                          **
**************************************************/

#include <sys/types.h>

#include "NPE_types.h"
#include "NPE_const.h"

extern PARAM    *AllParam;      /** Array of Structures of
				  All Parameters                   **/
extern uint      NumAllParam;   /** Number of All Parameters       **/
extern uint      NumVarParam;   /** Number of Variable Parameters  **/
extern uint      NumWave;       /** Number of Waves                **/
extern uint      DataPoint;     /** Data Point of Object Wave      **/
extern uint      Step;          /** Number of iteration            **/
extern int       StoreInterval; /** Interval of Parameter History  **/
extern uint      ScaleMethod;   /** Number of Scaling method       **/

extern PARAM   **VarParam;      /** Array of Pointers to
				  Variable Parameters              **/
extern double   *ModelParam;    /** Model Parameter                **/
extern double  **WaveData;      /** Experiment Wave Data           **/
extern double  **WeightData;    /** Weight of error function       **/
extern double   *Output;        /** Output of model                **/
extern double    ErrorValue;    /** Value of Error                 **/
extern double    DispValue;
extern double    tmpDisp;
extern double    PenaltyValue;  /** Value of Penalty               **/
extern double    tmpPena;
extern double   *Err;           /** Errors ( Simplex Only )        **/
extern double    samp;          /** Sampling Frequency             **/

#include "NPE_proto.h"
