/**************************************************
**  NPE.h                                        **
**  Header file for NPE                          **
**************************************************/

#include <sys/types.h>

#include "NPE_types.h"
#include "NPE_const.h"

/** Array of Structures of All Parameters  **/
PARAM     *AllParam;

/** Number of All Parameters **/
uint       NumAllParam;

/** Number of Variable Parameters **/
uint       NumVarParam;

/** Number of Waves **/
uint       NumWave;

/** Data Point of Object Wave **/
uint       DataPoint;

/** Number of iteration **/
uint       Step;

/** Interval of Parameter Histry **/
int        StoreInterval;

/** Number of Scaling method **/
uint       ScaleMethod;

/** Array of Pointers to Variable Parameters  **/
PARAM    **VarParam;

/** Model Parameter **/
double    *ModelParam;

/** Experiment Wave Data **/
double   **WaveData;

/** Weight of error function **/
double   **WeightData;

/** Output of model **/
double    *Output;

/** Value of Error **/
double     ErrorValue;
double     DispValue;
double     tmpDisp;     /* usr in lib*.c     */

/** Value of Penalty **/
double     PenaltyValue;
double     tmpPena;     /* usr in lib*.c     */

/** Errors ( Simplex Only ) **/
double    *Err;

/** Sampling Frequency  **/
double     samp;

#include "NPE_proto.h"
