/**************************************************
**  NPE_const.h                                  **
**  Header file in order to state                **
**  the constant value for estimation            **
**************************************************/

#if !defined(__NPE_const__)
#define __NPE_const__

/* definition of NPE common area file name */
#define	NPECOMMONAREA	"npecommon.area"
/* definition of macro */
#define  square(X)    ((X)*(X))
#define  FIX          (0)       /** a value of "Param.flag"        **/
#define  VAR          (1)       /** a value of "Param.flag"        **/
#define  UPPER_LIMIT  (10000)   /** value of Upper Limit           **/
#define SKIP(c)       while(c!=NULL&&(*c==' '||*c=='\t'))c++

#if !defined(TRUE)
#define TRUE          (1)
#endif

#if !defined(FALSE)
#define FALSE         (0)
#endif


/* DisplayError type */
#if !defined(NO_WEIGHT)
#define  NO_WEIGHT   (0)
#endif

#if !defined(WITH_WEIGHT)
#define  WITH_WEIGHT (1)
#endif

/* Norm type */
#define  NORM_INF  0
#define  NORM_ONE  1
#define  NORM_TWO  2

#define MAXPARAMNAME  (25)

#define NAMESIZE  (MAXPARAMNAME+1)

#define getValue(P)  ((P.value*P.scale))

#define  MAXFNAME  (128)
#define  MAXLINE   (128)

/* model type */
#define USR      (1)
#define NCS      (2)

#define METHOD   (1)
#define LSEARCH  (2)
#define MODEL    (3)
#define INIT     (4)
#define SCALE    (5)
#define TERM     (6)
#define NUMBER   (7)
#define POINT    (8)
#define EXPERIMENT  (9)
#define DATA     (9)
#define WEIGHT   (10)
#define RESULT   (11)
#define HISTORY  (12)
#define XINTEG   (13)
#define PENALTY  (14)
#define DISPLAY  (15)
#define NORM     (16)
#define BLOCK    (17)
#define SET      (18)

#define ELEMENTNUMBER	  (19)    /* for elementCheckTable */

#endif  /* __NPE_const__ */
