/**************************************************
**  NPE_proto.h                                  **
**  Header file in order to state                **
**  the prototype of NPE library                 **
**************************************************/

#ifndef __NPE_proto__
#define __NPE_proto__

#undef _ANSI_ARGS_
#if ( defined(__STDC__) && !defined(NO_PROTOTYPE)) || defined(ANSI)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)       x
#else
#   define _ANSI_ARGS_(x)       ()
#endif

/** Error Function          **/
extern double  errorFunc          _ANSI_ARGS_((PARAM *AllParam));

/** penalty Function        **/
extern double  penalty            _ANSI_ARGS_((double *param));

/** Scale Transformation    **/
extern int     scaleTrans         _ANSI_ARGS_((PARAM **varParam));

/** Allocate Memory         **/
extern void   *malloc2Dim         _ANSI_ARGS_((int m, int n, int types));

/** Display Err.& Parameter **/
extern void    display            _ANSI_ARGS_((PARAM *param,
					       double errorValue));

/** Read Initial Parameters **/
extern int     readParam          _ANSI_ARGS_((void));

/** Read Data               **/
extern void    readData           _ANSI_ARGS_((void));

/** Read Scale Method       **/
extern void    readScaleMethod    _ANSI_ARGS_((void));

/** Read Store File Names   **/
extern int     readStoreFile      _ANSI_ARGS_((void));

/** Read Terminal Criterion **/
extern int     readTermCriterion  _ANSI_ARGS_((void));

/** Read System Parameters  **/
extern void    readSystemParam    _ANSI_ARGS_((double *samp));

/** Store Data              **/
extern void    dataStore          _ANSI_ARGS_((PARAM *Param));

/** Store Parameter Histry  **/
extern int     storeParamHist     _ANSI_ARGS_((PARAM *Param, int finalFlag));

/** Copy Parameters (only for simplex method) **/
extern void    paramCopy          _ANSI_ARGS_((PARAM **source, PARAM **dest));

/** Check Terminate Crite.  **/
extern BOOL    term               _ANSI_ARGS_((void));

/** Set Signal              **/
extern void    setSignal          _ANSI_ARGS_(());

/** Used in Linear Search   **/
extern void    interpolation      _ANSI_ARGS_((void));

/** Differentiate Params    **/
extern double  differentiate      _ANSI_ARGS_((PARAM *vParam[], 
					       double *nablaFx,
					       double *direction));

/** Signum Function         **/
extern double  sgn                _ANSI_ARGS_((double x));

#endif /* __NPE_proto__ */
