/**************************************************
**  NPEcmd.h                                     **
**  Header file for NPE common area              **
**************************************************/
#ifndef ___NPEcmd___
#define ___NPEcmd___

#include "NPE_const.h"
#include "NPE_dirs.h"

#ifndef  MAXPARAMNAME
#define  MAXPARAMNAME  (25)
#endif


typedef struct Method {          /* %method */
  int             elmntnum;      /* element number */
  char           *fname;         /* file name */
  struct Method  *next;          /* next pointer */
} Method;

typedef struct Lsearch {         /* %linearsearch */
  int              elmntnum;
  char            *fname;
  double           value;        /* search length */
  struct Lsearch  *next;
} Lsearch;

typedef struct Model {           /* %model */
  int             elmntnum;
  int             type;          /* model type */
  union {
    struct usr {                 /* C, FORTRAN model */
      char  *fname;
    } Usr;
    struct ncs {
      char  *fname;
    } Ncs;                       /* NCS model */
  }               inform;
  struct  Model  *next;
} Model;

typedef struct Penalty {         /* %penalty */
  int              elmntnum;
  char            *fname;
  struct Penalty  *next;
} Penalty;

typedef struct Init {            /* %init */
  int              elmntnum;
  int              paramnum;     /* number of element */
  struct  estparam {
    double            value;     /* init value */
    int               flag;      /* FIX or VAR */
    char              name[MAXPARAMNAME+1];  /* parameter name */
    double            span;
    struct estparam  *next;
  }                  *EstParam;  /* pointer of parameter */
  struct  Init       *next;
} Init;

typedef struct Scale {           /* %scale */
  int            elmntnum;
  int            scalemethod;    /* scale method */
  struct Scale  *next;
} Scale;

typedef struct Term {            /* %term */
  int                 elmntnum;
  char               *logic;     /* logic of term criterion */
  struct  termcrite {
    int               critenum;  /* criterion number */
    double            critevalue;/* criterion value */
    struct termcrite *next;
  }                  *TermCrite; /* pointer of term croterion */
  struct  Term       *next;
} Term;

typedef struct Number {          /* %number */
  int             elmntnum;
  int             numwave;       /* number of wave */
  struct Number  *next;
} Number;

typedef struct Point {           /* %point */
  int            elmntnum;
  int            datapoint;      /* data point */
  struct Point  *next;
} Point;

typedef struct Experiment {      /* %experiment */
  int                elmntnum;
  char              *fname;
  int                recnum;     /* record number */
  struct Experiment *next;
} Experiment;

typedef struct Weight {          /* weight */
  int             elmntnum;
  char           *fname;
  int             recnum;
  struct Weight  *next;
} Weightt;

typedef struct Result {          /* result */
  int             elmntnum;
  char           *fname;
  int             buffnum;
  int             storeinterval; /* store interval */
  struct Result  *next;
} Result;

typedef struct History {         /* history */
  int              elmntnum;
  char            *fname;
  int              buffnum;
  int              storeinterval;/* store interval */
  struct History  *next;
} History;

typedef struct Xinteg {          /* %xinteg */
  int             elmntnum;
  char            integmethod;   /* integration method */
  char            dummy[3];
  struct Xinteg  *next;
} Xinteg;

typedef struct Display {         /*  %display  */
  int  elmntnum;
  int  type;                     /* display type */
} Display;

typedef struct Norm {            /*  %norm  */
  int  elmntnum;
  int  type;                     /*  norm type */
} Norm;

typedef struct Block {
  struct element {
    int              type;
    int              num;
    struct element  *next;
  } *Element;
  struct Block      *next;
} Block;

typedef struct Set {
  Method      *methodp;
  Lsearch     *lsearchp;
  Model       *modelp;
  Penalty     *penaltyp;
  Init        *initp;
  Scale       *scalep;
  Term        *termp;
  Number      *numberp;
  Point       *pointp;
  Experiment  *datap;
  Weightt     *weightp;
  Result      *resultp;
  History     *historyp;
  Xinteg      *xintegp;
  Display     *dispp;
  Norm        *normp;
  struct Set  *next;
} Set;


#include "NPE_types.h"
#include "NPE_proto.h"

#endif /* ___NPEcmd___ */
/* --- end of NPEcmd.h --- */
