/**************************************************
**  common1.c                                    **
**  common area handle functions                 **
**************************************************/

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "NPEcmd.h"
#include "ex_global_vars.h"

#if !defined(NPECOMMONAREA)
#define	NPECOMMONAREA	"npecommon.area"
#endif

FILE	*commonfp1; /* commonfp1 : usr for reading the file */
                    /* Use in common2.c,   NPEload.c, 
                              setmethod.c, setpenalty.c */
int     StoreFlag;

/***************************
** functions in this file **
****************************/
/* function prototype */
#if defined(ANSI)
void  renpe(void);
void  renpe_(char *filename);
void  initHead(void);
int   searchIdent(char ident, int *type);
int   getElementType(char *cp);
int   getElementLength(int type);
void  mallocElement(int type);
void  mallocMethod(void);
void  mallocLsearch(void);
void  mallocPenalty(void);
void  mallocModel(void);
void  mallocInit(void);
void  mallocScale(void);
void  mallocTerm(void);
void  mallocNumber(void);
void  mallocPoint(void);
void  mallocExperiment(void);
void  mallocWeight(void);
void  mallocResult(void);
void  mallocHistory(void);
void  mallocXinteg(void);
void  mallocDisplay(void);
void  mallocNorm(void);
void  mallocSet(void);
void  freeMethod(Method *wp);
void  freeLsearch(Lsearch  *wp);
void  freeModel(Model  *wp);
void  freePenalty(Penalty  *wp);
void  freeInit(Init *wp);
void  freeEstParam(struct estparam  *wp);
void  freeScale(Scale  *wp);
void  freeTerm(Term  *wp);
void  freeTermCrite(struct termcrite  *wp);
void  freeNumber( Number  *wp );
void  freePoint(Point  *wp);
void  freeExperiment(Experiment  *wp);
void  freeWeight(Weightt  *wp);
void  freeResult(Result  *wp);
void  freeHistory(History  *wp);
void  freeXinteg(Xinteg  *wp);
void  freeDisplay(Display *wp);
void  freeNorm(Norm *wp);
void  freeBlock(Block  *wp);
void  freeSet1(Set  *wp);
void  freeSet(Block  *B, Set  *S);
void  freeElement(struct element	*wp);
void  setElementAddress(Set  *S, int type, int num);
int   NextLine(char *line);
char  *strcopy(char *s);
#else
void  renpe();
void  renpe_();
void  initHead();
int   searchIdent();
int   getElementType();
int   getElementLength();
void  mallocElement();
void  mallocMethod();
void  mallocLsearch();
void  mallocPenalty();
void  mallocModel();
void  mallocScale();
void  mallocTerm();
void  mallocNumber();
void  mallocPoint();
void  mallocExperiment();
void  mallocWeight();
void  mallocResult();
void  mallocHistory();
void  mallocXinteg();
void  mallocDisplay();
void  mallocNorm();
void  mallocSet();
void  freeMethod();
void  freeLsearch();
void  freeModel();
void  freePenalty();
void  freeInit();
void  freeEstParam();
void  freeScale();
void  freeTerm();
void  freeTermCrite();
void  freeNumber();
void  freePoint();
void  freeExperiment();
void  freeWeight();
void  freeResult();
void  freeHistory();
void  freeXinteg();
void  freeDisplay();
void  freeNorm();
void  freeBlock();
void  freeSet1();
void  freeSet();
void  freeElement();
void  setElementAddress();
int   NextLine();
char  *strcopy();
#endif

/****************************************************
** renpe() reads information form NPE common area. **
*****************************************************/
void renpe(void)
{
  char	fname[MAXFNAME];

  fname[0] = '\0';
  renpe_( fname );
}

void renpe_(char  *filename )
{
  int	type;
  char  line[MAXLINE];

  if( *filename == '\0' ) {

    read_syscom();
    strcpy( filename, syscom.temp_dir );
    strcat( filename, NPECOMMONAREA   );

    if( (commonfp1=fopen( filename, "r" )) == NULL ) {
      exit( 150 );
    }
    fgets( line, MAXLINE, commonfp1 );
    sscanf( line, "%d", &StoreFlag );
  } else  {
    if( (commonfp1=fopen( filename, "r" )) == NULL ) {
      exit( 150 );
    }
  }

  initHead();

  while( searchIdent( '%', &type ) != -1 ) {
    mallocElement( type );
  }

  rewind( commonfp1 ); /* set commonfp1 to the top */
  while( searchIdent( '#', &type) != -1 ) {
      mallocSet(); 
  }

  if( SetHead == NULL ) {
      mallocSet(); 
  }
  fclose( commonfp1 );
}

/*****************************************************
** Following functions are component of re/wrnpe(). **
******************************************************/

void  initHead(void)
{
  freeMethod( MethodHead );	freeLsearch( LsearchHead ); 
  freeModel ( ModelHead  );	freeInit   ( InitHead    ); 
  freeScale ( ScaleHead  );	freeExperiment  ( ExperimentHead );
  freeTerm  ( TermHead   );	freePoint  ( PointHead   ); 
  freeNumber( NumberHead );	freeWeight ( WeightHead  ); 
  freeResult( ResultHead );	freeHistory( HistoryHead );
  freeXinteg( XintegHead );	freeDisplay( DisplayHead );
  freeNorm( NormHead );         freePenalty( PenaltyHead );
  freeSet( BlockHead, SetHead  );
  MethodHead = NULL;	LsearchHead = NULL;
  ModelHead = NULL;	InitHead = NULL;
  ScaleHead = NULL;	ExperimentHead = NULL;
  TermHead = NULL;	PointHead = NULL;
  NumberHead = NULL;	WeightHead = NULL;
  ResultHead = NULL;	HistoryHead = NULL;
  XintegHead = NULL;	DisplayHead = NULL;
  NormHead = NULL;      BlockHead = NULL;
  PenaltyHead = NULL;   SetHead    = NULL;
}


int  searchIdent(char ident, int *type)
{
  char  *cp, line[MAXLINE];
	
  while( (cp=fgets( line, MAXLINE, commonfp1 )) != NULL ) {
    SKIP(cp);
/* if character( not spc or tab) = identifer */
    if( *cp++ == ident ) {
      SKIP(cp);
      *type = getElementType( cp );     
      cp   += getElementLength( *type );
      return( 0 );
    }
  }
  return( -1 ); /* could not read a line from commonfp1 */
}

/* check the type of environment variable */
#if !defined(EL_TYPE_MDL)
#define  EL_TYPE_MDL  3
#endif

int	getElementType(char *cp )
{
  if( strncmp( cp, "data",    EL_TYPE_MDL ) == 0 )  return( DATA );
  if( strncmp( cp, "display", EL_TYPE_MDL ) == 0 )  return( DISPLAY );
  if( strncmp( cp, "history", EL_TYPE_MDL ) == 0 )  return( HISTORY );
  if( strncmp( cp, "init",    EL_TYPE_MDL ) == 0 )  return( INIT );
  if( strncmp( cp, "lsearch", EL_TYPE_MDL ) == 0 )  return( LSEARCH );
  if( strncmp( cp, "method",  EL_TYPE_MDL ) == 0 )  return( METHOD );
  if( strncmp( cp, "model",   EL_TYPE_MDL ) == 0 )  return( MODEL );
  if( strncmp( cp, "norm",    EL_TYPE_MDL ) == 0 )  return( NORM );
  if( strncmp( cp, "number",  EL_TYPE_MDL ) == 0 )  return( NUMBER );
  if( strncmp( cp, "penalty", EL_TYPE_MDL ) == 0 )  return( PENALTY );
  if( strncmp( cp, "point",   EL_TYPE_MDL ) == 0 )  return( POINT );
  if( strncmp( cp, "result",  EL_TYPE_MDL ) == 0 )  return( RESULT );
  if( strncmp( cp, "scale",   EL_TYPE_MDL ) == 0 )  return( SCALE );
  if( strncmp( cp, "set",     EL_TYPE_MDL ) == 0 )  return( SET );
  if( strncmp( cp, "term",    EL_TYPE_MDL ) == 0 )  return( TERM );
  if( strncmp( cp, "weight",  EL_TYPE_MDL ) == 0 )  return( WEIGHT );
  if( strncmp( cp, "xinteg",  EL_TYPE_MDL ) == 0 )  return( XINTEG );
  return( -1 );
}


/* check the character length of environment variable */
int	getElementLength(int type )
{
  switch( type ) {
    case METHOD  : return( strlen("method") );
    case LSEARCH : return( strlen("lsearch") );
    case MODEL   : return( strlen("model") );
    case PENALTY : return( strlen("penalty") );
    case INIT    : return( strlen("init") );
    case SCALE   : return( strlen("scale") );
    case TERM    : return( strlen("term") );
    case NUMBER  : return( strlen("number") );
    case POINT   : return( strlen("point") );
    case DATA    : return( strlen("data") );
    case WEIGHT  : return( strlen("weight") );
    case RESULT  : return( strlen("result") );
    case HISTORY : return( strlen("history") );
    case XINTEG  : return( strlen("xinteg") );
    case DISPLAY : return( strlen("display") );
    case NORM    : return( strlen("norm") );
    case SET     : return( strlen("set") );
    default      : exit( 152 );
  }
  return(-1);
}


/* allocate the memory of each Element */
void  mallocElement(int type)
{
  switch( type ) {
    case METHOD :   mallocMethod();
       break;
    case LSEARCH :  mallocLsearch();
      break;
    case MODEL :    mallocModel();
      break;
    case PENALTY :  mallocPenalty();
      break;
    case INIT :     mallocInit();
      break;
    case SCALE :    mallocScale();
      break;
    case TERM :     mallocTerm();
      break;
    case NUMBER :   mallocNumber();
      break;
    case POINT :    mallocPoint();
      break;
    case DATA :     mallocExperiment();
      break;
    case WEIGHT :   mallocWeight();
      break;
    case RESULT :   mallocResult();
      break;
    case HISTORY :  mallocHistory();
      break;
    case XINTEG :   mallocXinteg();
      break;
    case DISPLAY :  mallocDisplay();
      break;
    case NORM :     mallocNorm();
      break;
  }
}


/* read each environment variable and set it to "struct" */

void mallocMethod(void)
{
  Method  *work;
  char    *cp, *charp, line[MAXLINE];

  if( MethodHead == NULL ) {
    if( (work=(Method *)malloc(sizeof(Method))) == NULL )
      exit( 1 );
    MethodHead = work;
  } else {
    free(MethodHead->fname);
  }
  MethodHead->elmntnum = -1;
  MethodHead->fname = NULL;
  MethodHead->next = NULL;

  /* if there is no corresponding optimization method */
  if( NextLine(line) == -1 ) { 
    MethodHead->fname = NULL;
    exit( 154 );
  }
  charp = line;

  /* optimization method */
  cp = strtok( charp, " ,\n\t:" );
  MethodHead->fname = strcopy( cp );
}

/* free() for METHOD */
void  freeMethod(Method *wp)
{
  if( wp == NULL )  return;

  /* 1.free() next part of current part */
  freeMethod( wp->next );

  /* 2.free() current part */
  free( wp->fname );
  free( wp );
}


void mallocLsearch(void)
{
  Lsearch  *work;
  char     *cp, *charp, line[MAXLINE];

  if( LsearchHead == NULL ) {
    if( (work=(Lsearch *)malloc(sizeof(Lsearch))) == NULL )
      exit( 1 );
    LsearchHead = work;
  } else {
    free(LsearchHead->fname);
  }
  LsearchHead->elmntnum = -1;
  LsearchHead->fname = NULL;
  LsearchHead->value    = 0.0;
  LsearchHead->next     = NULL;

  if( NextLine(line) == -1 ) {
    LsearchHead->fname = NULL;
    exit( 154 );
  }
  charp = line;

  /* linear search method */
  cp = strtok( charp, " ,\t\n" );
  LsearchHead->fname = strcopy( cp );

  /* step size */
  cp = strtok( NULL, " ,\t\n:" );
  sscanf( cp, "%lf", &LsearchHead->value );
}

void  freeLsearch(Lsearch  *wp)
{
  if( wp == NULL )  return;

  freeLsearch( wp->next );
  free( wp->fname );
  free( wp );
}


void  mallocModel(void)
{
  Model  *work = NULL;
  char   *cp, *charp, line[MAXLINE];

  if( ModelHead == NULL ) {
    if( (work=(Model *)malloc(sizeof(Model))) == NULL )
      exit( 1 );
    ModelHead = work;
  } else {
    switch(ModelHead->type){
    case USR: free( ModelHead->inform.Usr.fname     ); break;
    case NCS: free( ModelHead->inform.Ncs.fname     ); break;
    }
  }
  ModelHead->elmntnum  = -1;
  ModelHead->next  = NULL;
	
  if( NextLine(line) == -1 ) {
    ModelHead->type = 0;
    exit( 154 );
  }
  charp = line;

  /* model type */
  cp = strtok( charp, " ,\t\n" );
  sscanf( cp, "%d", &ModelHead->type );

  /* object file name of the model  */
  cp = strtok( NULL, " ,\n\t:" );
  switch( work->type ) {
    case USR   :
      ModelHead->inform.Usr.fname = strcopy( cp );
      break;
    case NCS   :
      ModelHead->inform.Ncs.fname = strcopy( cp );
      break;
    default    : exit( 54 );
  }
}

void  freeModel(Model	*wp)
{
  if( wp == NULL )
    return;

  freeModel( wp->next );
  switch( wp->type ){
     case USR:	free( wp->inform.Usr.fname     ); break;
     case NCS:	free( wp->inform.Ncs.fname     ); break;
  }
  free( wp );
}


void  mallocPenalty(void)
{
  Penalty  *work;
  char  *cp, *charp, line[MAXLINE];

  if( PenaltyHead == NULL ) {
    if( (work=(Penalty *)malloc(sizeof(Penalty))) == NULL )
      exit( 1 );
    PenaltyHead = work;
  } else {
    free(PenaltyHead->fname);
  }
  PenaltyHead->elmntnum = -1;
  PenaltyHead->fname = NULL;
  PenaltyHead->next = NULL;

  if( NextLine(line) == -1 ) {
    PenaltyHead->fname = NULL;
    exit( 154 );
  }
  charp = line;

/* object file name of penalty */
  cp = strtok( charp, " ,\n\t:" );
  PenaltyHead->fname = strcopy( cp );
}


void  freePenalty(Penalty  *wp)
{
  if( wp == NULL )  return;

  freePenalty( wp->next );
  free( wp->fname );
  free( wp );
}


void  mallocInit(void)
{
  Init  *work;
  int   i;
  char  *cp, ch, *charp, line[MAXLINE];
  struct estparam  *p, *ptail;

  if( InitHead == NULL ) {
    if((work = (Init *)malloc(sizeof(Init))) == NULL )
      exit( 1 );
    InitHead = work;
  } else {
    freeEstParam(InitHead->EstParam);
  }

  InitHead->elmntnum = -1;
  InitHead->EstParam = NULL;
  InitHead->next = NULL;

  if( NextLine(line) == -1 ) {
    InitHead->paramnum = 0;
    exit( 154 );
  }
  charp = line;

 /* number of parameter */
  cp = strtok( charp, " \t\n:" );
  sscanf( cp, "%u", &InitHead->paramnum );

  /* set the initial value */
  for( ptail=NULL,i=0; i<InitHead->paramnum; i++ ) {
    if( NextLine(line) == -1 )
      exit( 155 );
    charp = line;
    if( (p=(struct estparam *)malloc(sizeof(struct estparam))) == NULL )
      exit( 1 );
    if( ptail == NULL ) {
      InitHead->EstParam = p;
      ptail = p;
    } else {
      ptail->next = p; /* add to tail */
      ptail = p;
    }
    p->value  = 0.0;  p->flag    = VAR;
    p->span   = 1.0;  p->next    = NULL;

    /* initial value */
    cp = strtok( charp, " ,\t" );
    sscanf( cp, "%lf", &p->value );

    /* Fix or Variable */
    cp = strtok( NULL, " ,\t" );
    sscanf( cp, "%c", &ch );
    if( ch=='f' || ch=='F' )
       p->flag = FIX;
    else  p->flag = VAR;

    /* name of variable */
    cp = strtok( NULL, " ,\t" );
    strncpy( p->name, cp, MAXPARAMNAME );

    /* span */
    cp = strtok( NULL, " ,\t:" );
    sscanf( cp, "%lf", &p->span );
  }
}

void  freeInit(Init  *wp)
{
  if( wp == NULL ) return;

  freeInit( wp->next );
  freeEstParam( wp->EstParam );
  free( wp );
}

/* free() the "struct" which is holding the initial value */
void  freeEstParam(struct estparam  *wp)
{
  if( wp == NULL ) return;

  freeEstParam( wp->next );
  free( wp );
}


void  mallocScale(void)
{
  Scale  *work;
  char   *cp = NULL, *charp, line[MAXLINE];

  if( ScaleHead == NULL ) {
    if( (work=(Scale *)malloc(sizeof(Scale))) == NULL )
      exit( 1 );
    ScaleHead = work;
  } 
  ScaleHead->elmntnum = -1;
  ScaleHead->scalemethod = 0;
  ScaleHead->next = NULL;

  if( NextLine(line) == -1 ) {
    ScaleHead->scalemethod = 0;
    exit( 154 );
  }
  charp = line;

  /* get the scaling method */
  cp = strtok( charp, " :\t\n" );
  sscanf( cp, "%d", &ScaleHead->scalemethod );
  if( (ScaleHead->scalemethod < 0) || (3 < ScaleHead->scalemethod) )
    exit( 156 );
}

void  freeScale(Scale  *wp)
{
  if( wp == NULL )  return;

  freeScale( wp->next );
  free( wp );
}


void  mallocTerm(void)
{
  Term   *work;
  struct termcrite *t, *tail;
  int    critenum;
  double  critevalue;
  char    *cp, *charp, line[MAXLINE];

  if( TermHead == NULL ) {
    if( (work=(Term *)malloc(sizeof(Term))) == NULL )
      exit( 1 );
    TermHead = work;
    TermHead->logic = NULL;
  } else {
    freeTermCrite(TermHead->TermCrite);
  }

  TermHead->elmntnum = -1;
  TermHead->next = NULL;
  TermHead->TermCrite = NULL;

  if( NextLine(line) == -1 ) {
    TermHead->logic = NULL;
    TermHead->TermCrite = NULL;
    exit( 154 );
  }
  charp = line;

  /* logical equation */
  cp = strtok( charp, ":\n" );
  TermHead->logic = strcopy( cp );

  /* get the value of each logic */
  tail = NULL;
  for( ; NextLine(line)!=-1; ) {
    charp = line;
    /* kind of the logic */
    cp = strtok( charp, " ,\t" );
    sscanf( cp, "%d", &critenum );
    if( (critenum < 0) || (9 < critenum) ) {
      exit( 158 );
    }
    /* value of the logic */
    cp = strtok( NULL, " ,\n\t:" );
    sscanf( cp, "%lf", &critevalue );
    /* check whether the critenum is exist or not */
    for(t=TermHead->TermCrite; t != NULL; t = t->next)
       if(t->critenum == critenum) break;

    if(t == NULL){ /* in the case of new critenum */
      if( (t=(struct termcrite *)malloc(sizeof(struct termcrite))) == NULL )
        exit( 1 );

      if( tail == NULL ) {
        TermHead->TermCrite = t;
        tail = t;
      } else {
        tail->next = t;  /* add to the tail */
      tail = t;
      }
      t->next = NULL;
    }
    t->critenum = critenum; t->critevalue = critevalue;
  }
}

void  freeTerm(Term  *wp)
{
  if( wp == NULL )  return;

  freeTerm( wp->next );
  free( wp->logic );
  freeTermCrite( wp->TermCrite );
  free( wp );
}


void  freeTermCrite(struct termcrite  *wp)
{
  if( wp == NULL )  return;

  freeTermCrite( wp->next );
  free( wp );
}


void  mallocNumber(void)
{
  Number  *work;
  char    *cp, *charp, line[MAXLINE];

  if( NumberHead == NULL ) {
    if( (work=(Number *)malloc(sizeof(Number))) == NULL )
      exit( 1 );
    NumberHead = work;
  } 
  NumberHead->elmntnum = -1;
  NumberHead->next = NULL;

  if( NextLine(line) == -1 ) {
    NumberHead->numwave = 0;
    exit( 154 );
  }
  charp = line;

  /* get the number */
  cp = strtok( charp, " :\t\n" );
  sscanf( cp, "%d", &NumberHead->numwave );
}

void  freeNumber( Number  *wp )
{
  if( wp == NULL ) return;

  freeNumber( wp->next );
  free( wp );
}


void  mallocPoint(void)
{
  Point  *work;
  char   *cp, *charp, line[MAXLINE];

  if( PointHead == NULL ) {
    if( (work=(Point *)malloc(sizeof(Point))) == NULL )
      exit( 1 );
    PointHead = work;
  }

  PointHead->elmntnum = -1;
  PointHead->next = NULL;

  if( NextLine(line) == -1 ) {
    PointHead->datapoint = 0;
    exit( 154 );
  }
  charp = line;

  /* get the output number  */
  cp = strtok( charp, " :\t\n" );
  sscanf( cp, "%d", &PointHead->datapoint );
}


void  freePoint(Point  *wp)
{
  if( wp == NULL ) return;

  freePoint( wp->next );
  free( wp );
}


void  mallocExperiment(void)
{
  Experiment  *work;
  char  *cp, *charp, line[MAXLINE];

  if( ExperimentHead == NULL ) {
    if( (work=(Experiment *)malloc(sizeof(Experiment))) == NULL )
      exit( 1 );
    ExperimentHead = work;
  } else {
    free(ExperimentHead->fname);
  }

  ExperimentHead->elmntnum = -1;
  ExperimentHead->fname = NULL;
  ExperimentHead->next = NULL;

  if( NextLine(line) == -1 ) {
    ExperimentHead->fname  = NULL;
    exit( 154 );
  }
  charp = line;

  /* get the data file name */
  cp = strtok( charp, " ,\n\t" );
  ExperimentHead->fname = strcopy( cp );

}

void  freeExperiment(Experiment  *wp)
{
  if( wp == NULL )  return;

  freeExperiment( wp->next );
  free( wp->fname );
  free( wp );
}


void  mallocWeight(void)
{
  Weightt  *work;
  char  *cp, *charp, line[MAXLINE];

  if( WeightHead == NULL ) {
    if( (work=(Weightt *)malloc(sizeof(Weightt))) == NULL )
      exit( 1 );
    WeightHead = work;
  } else {
    free(WeightHead->fname);
  }

  WeightHead->elmntnum = -1;
  WeightHead->fname = NULL;
  WeightHead->next = NULL;

  if( NextLine(line) == -1 ) {
    WeightHead->fname  = NULL;
    exit( 154 );
  }
  charp = line;

  /* get the weight file name */
  cp = strtok( charp, " ,\n\t" );
  WeightHead->fname = strcopy( cp );
}

void  freeWeight(Weightt  *wp)
{
  if( wp == NULL ) return;

  freeWeight( wp->next );
  free( wp->fname );
  free( wp );
}


void  mallocResult(void)
{
  Result  *work;
  char  *cp, *charp, line[MAXLINE];

  if( ResultHead == NULL ) {
    if( (work=(Result *)malloc(sizeof(Result))) == NULL )
      exit( 1 );
    ResultHead = work;
  } else {
    free(ResultHead->fname);
  }
  ResultHead->elmntnum = -1;
  ResultHead->fname = NULL;
  ResultHead->storeinterval = 1;
  ResultHead->buffnum = 0;
  ResultHead->next = NULL;

  if( NextLine(line) == -1 ) {
    ResultHead->fname  = NULL;
    ResultHead->storeinterval = 1;
    exit( 154 );
  }
  charp = line;

  /* get the result file name */
  cp = strtok( charp, " ,\n\t" );
  ResultHead->fname = strcopy( cp );
}

void  freeResult(Result  *wp)
{
  if( wp == NULL )  return;

  freeResult( wp->next );
  free( wp->fname );
  free( wp );
}


void  mallocHistory(void)
{
  History  *work;
  char  *cp, *charp, line[MAXLINE];


  if( HistoryHead == NULL ) {
    if( (work=(History *)malloc(sizeof(History))) == NULL )
      exit( 1 );
    HistoryHead = work;
  } else {
    free(HistoryHead->fname);
  }

  HistoryHead->elmntnum = -1;
  HistoryHead->fname    = NULL;
  HistoryHead->storeinterval = 1;
  HistoryHead->buffnum = 0;
  HistoryHead->next = NULL;

  if( NextLine(line) == -1 ) {
    HistoryHead->fname        = NULL;
    HistoryHead->storeinterval = 1;
    exit( 154 );
  }
  charp = line;

  /* get the history file name */
  cp = strtok( charp, " ,\n\t" );
  HistoryHead->fname = strcopy( cp );

  /* get store interval */
  cp = strtok( NULL, " ,\n\t:" );
  if(sscanf( cp, "%d", &HistoryHead->storeinterval ) == EOF ){
     HistoryHead->storeinterval = 1;
  } else {
    if( HistoryHead->storeinterval == 0 )
      HistoryHead->storeinterval = 1;
  }
}

void  freeHistory(History  *wp)
{
  if( wp == NULL ) return;

  freeHistory( wp->next );
  free( wp->fname );
  free( wp );
}


void  mallocXinteg(void)
{
  Xinteg  *work;
  char  *cp, *charp, line[MAXLINE];

  if( XintegHead == NULL ) {
    if( (work=(Xinteg *)malloc(sizeof(Xinteg))) == NULL )
      exit( 1 );
    XintegHead = work;
  }

  XintegHead->elmntnum = -1;
  XintegHead->next = NULL;

  if( NextLine(line) == -1 ) {
    XintegHead->integmethod = '\0';
    exit( 154 );
  }
  charp = line;

  /* get the cal. method of integration */
  cp = strtok( charp, " \t\n:" );
  sscanf( cp, "%c", &XintegHead->integmethod );
}

void  freeXinteg(Xinteg  *wp)
{
  if( wp == NULL )  return;

  freeXinteg( wp->next );
  free( wp );
}


void  mallocDisplay(void)
{
  Display  *work;
  char     *cp, *charp, line[MAXLINE];

  if(DisplayHead == NULL ){
    if( (work=(Display *)malloc(sizeof(Display))) == NULL )
      exit( 1 );
    DisplayHead = work;
  }
  DisplayHead->elmntnum = -1;
  DisplayHead->type = NO_WEIGHT;

  if(NextLine(line) == -1 ){
    exit( 154 );
  }

  charp = line;

  /* get the display type */
  cp = strtok( charp , " \t\n:");
  sscanf(cp, "%d", &DisplayHead->type);
}

void  freeDisplay(Display *wp)
{
  free(wp);
}


void  mallocNorm(void)
{
  Norm  *work;
  char  *cp, *charp, line[MAXLINE];

  if(NormHead == NULL ){
    if( (work=(Norm *)malloc(sizeof(Norm))) == NULL )
      exit( 1 );
    NormHead = work;
  }
  NormHead->elmntnum = -1;
  NormHead->type = NORM_TWO;

  if( NextLine(line) == -1 ){
    exit( 154 );
  }

  charp = line;

  /* get the norm type */
  cp = strtok( charp , " \t\n:");
  sscanf(cp, "%d", &NormHead->type);
}

void  freeNorm(Norm *wp)
{
  free(wp);
}


void  mallocSet(void)
{
  Block *workB = NULL;
  Set   *workS = NULL;

  if( BlockHead == NULL ) {
    if((workB = (Block *)malloc(sizeof(Block))) == NULL)
      exit( 1 );
    BlockHead = workB;
  } else {
    freeElement(BlockHead->Element);
  }
  BlockHead->Element  = NULL;
  BlockHead->next     = NULL;

  if( SetHead == NULL ) {
    if((workS = (Set *)malloc(sizeof( Set ))) == NULL)
      exit( 1 );
    SetHead = workS;
  }

  SetHead->methodp  = MethodHead;
  SetHead->lsearchp = LsearchHead;
  SetHead->modelp   = ModelHead;
  SetHead->penaltyp = PenaltyHead;
  SetHead->initp    = InitHead;
  SetHead->scalep   = ScaleHead;
  SetHead->termp    = TermHead;
  SetHead->numberp  = NumberHead;
  SetHead->pointp   = PointHead;
  SetHead->datap    = ExperimentHead;
  SetHead->weightp  = WeightHead;
  SetHead->resultp  = ResultHead;
  SetHead->historyp = HistoryHead;
  SetHead->xintegp  = XintegHead;
  SetHead->dispp    = DisplayHead;
  SetHead->normp    = NormHead;
  SetHead->next     = NULL;

  /* levenson-marquart method dose not use the linear search */
  if( (SetHead->methodp != NULL ) && 
      (strcmp(SetHead->methodp->fname,"leven") == 0 )) {
    SetHead->lsearchp = NULL;
  } else if ( (SetHead->methodp != NULL) && 
              (strcmp(SetHead->methodp->fname,"simplex") == 0) ) {
		SetHead->scalep   = NULL;
		SetHead->lsearchp = NULL;
  }
}

void  freeBlock(Block  *wp)
{
  if( wp == NULL ) return;

  freeBlock( wp->next );
  freeElement( wp->Element );
  free( wp );
}

void  freeSet1(Set  *wp)
{
  if( wp == NULL ) return;

  freeSet1( wp->next );
  free( wp );
}

void  freeSet(Block  *B, Set  *S)
{
  /* first:free() block, second:free() Set */
  freeBlock( B );
  freeSet1 ( S );
}

void freeElement(struct element  *wp)
{
  if( wp == NULL )  return;

  freeElement( wp->next );
  free( wp );
}


void  setElementAddress(Set  *S, int type, int num)
{
  Method   *wMe;   Lsearch    *wLs;
  Model    *wMo;   Penalty    *wPe;
  Init     *wIn;   Scale      *wSc;
  Term     *wTe;   Number     *wNu;
  Point    *wPo;   Experiment *wEx;
  Weightt  *wWe;   Result     *wRe;
  History  *wHi;   Xinteg     *wXi;

  switch( type ) {
    case METHOD  : 
      for( wMe=MethodHead; wMe!=NULL; wMe=wMe->next ) {
        if( wMe->elmntnum == num )
        S->methodp = wMe;
      }
      break;
    case LSEARCH : 
      for( wLs=LsearchHead; wLs!=NULL; wLs=wLs->next ) {
        if( wLs->elmntnum == num )
        S->lsearchp = wLs;
      }
      break;
    case MODEL  : 
      for( wMo=ModelHead; wMo!=NULL; wMo=wMo->next ) {
        if( wMo->elmntnum == num )
        S->modelp = wMo;
      }
      break;
    case PENALTY: 
      for( wPe=PenaltyHead; wPe!=NULL; wPe=wPe->next ) {
        if( wPe->elmntnum == num )
        S->penaltyp = wPe;
      }
      break;
    case INIT  : 
      for( wIn=InitHead; wIn!=NULL; wIn=wIn->next ) {
        if( wIn->elmntnum == num )
        S->initp = wIn;
      }
      break;
    case SCALE  : 
      for( wSc=ScaleHead; wSc!=NULL; wSc=wSc->next ) {
        if( wSc->elmntnum == num )
        S->scalep = wSc;
      }
      break;
    case TERM  : 
      for( wTe=TermHead; wTe!=NULL; wTe=wTe->next ) {
        if( wTe->elmntnum == num )
        S->termp = wTe;
      }
      break;
    case NUMBER  : 
      for( wNu=NumberHead; wNu!=NULL; wNu=wNu->next ) {
        if( wNu->elmntnum == num )
        S->numberp = wNu;
      }
      break;
    case POINT  : 
      for( wPo=PointHead; wPo!=NULL; wPo=wPo->next ) {
        if( wPo->elmntnum == num )
        S->pointp = wPo;
      }
      break;
    case DATA :
      for( wEx=ExperimentHead; wEx!=NULL; wEx=wEx->next ) {
        if( wEx->elmntnum == num )
        S->datap = wEx;
      }
      break;
    case WEIGHT  : 
      for( wWe=WeightHead; wWe!=NULL; wWe=wWe->next ) {
        if( wWe->elmntnum == num )
        S->weightp = wWe;
      }
      break;
    case RESULT  : 
      for( wRe=ResultHead; wRe!=NULL; wRe=wRe->next ) {
        if( wRe->elmntnum == num )
        S->resultp = wRe;
      }
      break;
    case HISTORY: 
      for( wHi=HistoryHead; wHi!=NULL; wHi=wHi->next ) {
        if( wHi->elmntnum == num )
        S->historyp = wHi;
      }
      break;
    case XINTEG  : 
      for( wXi=XintegHead; wXi!=NULL; wXi=wXi->next ) {
        if( wXi->elmntnum == num )
        S->xintegp = wXi;
      }
      break;
    case DISPLAY :
      if( DisplayHead->elmntnum == num )
        S->dispp = DisplayHead;
      break;
    case NORM :
      if( NormHead->elmntnum == num )
        S->normp = NormHead;
      break;
    case SET  : break;
    default  : exit( 152 );
  }
}


/* commonfp1 and charp1 are global value */
/* set the pointer to next line */
int  NextLine(char *line)
{
  long int addr;
  char *charp;

  for( ; ; ) {
    addr  = ftell( commonfp1 );
    charp = fgets( line, MAXLINE, commonfp1 );
    if( charp == NULL ) return( -1 );

    SKIP( charp );         /* delete tab and spc */
    switch( *charp ) {
      case ':' : continue; /* case of comment line */
      case '%' :           /* case of element */
      case '#' : fseek( commonfp1, addr, 0 );
           return( -1 );
      default  : break;
    }
    break;
  }
  return(0);
}

/* copy the charcter type array  */
char  *strcopy(char  *s )
{
  int  len, charsize;
  char  *d;
  
  charsize = sizeof(char);
  if( s == NULL )
    return( NULL );
  len  = (int)(4/charsize)*(int)ceil((double)(strlen(s)*charsize)/4.0);
  if( (d=(char *)malloc((len+1)*charsize)) == NULL ) {
    exit( 1 );
  }
  strcpy( d, s );
  return( d );
}

/* end of common1.c */
