/**************************************************
**  common2.c                                    **
**  common area handle functions                 **
**************************************************/

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <string.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "NPEcmd.h"
#include "ex_global_vars.h"

#if !defined(NPECOMMONAREA)
#define	NPECOMMONAREA	"npecommon.area"
#endif

/*********************
** global variables **
**********************/
FILE	*commonfp2;     /* commonfp2 : use for writing the file */
                        /* commonfp1 : usr for reading the file */
extern int   StoreFlag; /* defined in common1.c */

/*--------------------------
*** function prototypes  ***
---------------------------*/

#if defined(ANSI)
void  wrnpe(void);
void  wrnpe_(char *fname, int storeflag);
void  wrnpe_2(char  *filename, int storeflag);
void  writeComment(void);

#else /* traditional */
void  wrnpe();
void  wrnpe_();
void  wrnpe_2();
void  writeComment();

#endif  /* ANSI */

/***************************************************
** wrnpe() writes information in NPE common area. **
***************************************************/
void  wrnpe(void)
{
  char  fname[MAXFNAME];

  fname[0] = '\0';
  wrnpe_( fname, FALSE );
}

void  wrnpe_(char *fname, int storeflag)
{
  if( *fname == '\0' ) {
    wrnpe_2( fname, storeflag );
  } else {
    wrnpe_2( fname, TRUE );
    *fname = '\0';
    wrnpe_2( fname, TRUE );
  }
}


void  wrnpe_2(char  *filename, int storeflag)
{
  struct estparam  *wEs;
  struct termcrite *wTc;

  if( *filename == '\0' ) {
    read_syscom();
    strcpy( filename, syscom.temp_dir );
    strcat( filename, NPECOMMONAREA   );

    if( (commonfp2=fopen( filename, "w" )) == NULL ) {
      exit( 150 );
    }
    StoreFlag = storeflag;
    fprintf( commonfp2, "%d\n", StoreFlag );
  } else {
    if( (commonfp2=fopen( filename, "w" )) == NULL ) {
      exit( 150 );
    }
  }

/* set the information to NPE common area */
/* Method */
  if(MethodHead != NULL){
    fprintf( commonfp2, "%%method\n%s", MethodHead->fname );
    writeComment();
  }

/* Lsearch */
  if(LsearchHead != NULL){
    fprintf( commonfp2, "%%lsearch\n%s,%g",
             LsearchHead->fname, LsearchHead->value );
    writeComment();
  }

/* Model */
  if(ModelHead != NULL){
    fprintf( commonfp2, "%%model\n%d,", ModelHead->type );

    switch( ModelHead->type ) {
      case USR :
        fprintf( commonfp2, "%s",
                 ModelHead->inform.Usr.fname );
        break;
      case NCS :
        fprintf( commonfp2, "%s",
                 ModelHead->inform.Ncs.fname );
        break;
    }
    writeComment();
  }

/* Penalty */
  if(PenaltyHead != NULL){
    fprintf( commonfp2, "%%penalty\n%s", PenaltyHead->fname );
    writeComment();
  }

/* Init */
  if( InitHead != NULL){
    fprintf( commonfp2, "%%init\n%d\n", InitHead->paramnum );
    for( wEs = InitHead->EstParam; wEs != NULL; wEs = wEs->next ) {
      fprintf( commonfp2, "%15.8g,\t%s,  %15s,   %g\n",
               wEs->value, ((wEs->flag==FIX)?"FIX":"VAR"),
               wEs->name,  wEs->span );
    }
    writeComment();
  }

/* Scale */
  if( ScaleHead != NULL ){
    fprintf( commonfp2, "%%scale\n%d", ScaleHead->scalemethod );
    writeComment();
  }

/* Term */
  if( TermHead != NULL ){
    if(TermHead->logic == NULL){
      fprintf(stderr, "No Specification: logic.\n");
      exit(20);
    }
    fprintf( commonfp2, "%%term\n%s", TermHead->logic );
    for( wTc = TermHead->TermCrite; wTc!=NULL; wTc=wTc->next ) {
      fprintf( commonfp2, "\n%d,%g",
               wTc->critenum, wTc->critevalue );
    }
    writeComment();
  }

/* Number */
  if( NumberHead != NULL ){
    fprintf( commonfp2, "%%number\n%d", NumberHead->numwave );
    writeComment();
  }

/* Point */
  if( PointHead != NULL ){
    fprintf( commonfp2, "%%point\n%d", PointHead->datapoint );
    writeComment();
  }

/* DATA */
  if( ExperimentHead != NULL ){
    fprintf( commonfp2, "%%data\n%s", ExperimentHead->fname );
    writeComment();
  }

/* Weight */
  if( WeightHead != NULL ){
    fprintf( commonfp2, "%%weight\n%s", WeightHead->fname );
    writeComment();
  }

/* Result */
  if( ResultHead != NULL ){
    fprintf( commonfp2, "%%result\n%s", ResultHead->fname );
    writeComment();
  }

/* History */
  if( HistoryHead != NULL ){
    fprintf( commonfp2, "%%history\n%s,%d",
             HistoryHead->fname, HistoryHead->storeinterval );
    writeComment();
  }

/* Xinteg */
  if( XintegHead != NULL ){
    fprintf( commonfp2, "%%xinteg\n%c",
             XintegHead->integmethod );
    writeComment();
  }

/* Display */
  if( DisplayHead != NULL ){
    fprintf( commonfp2, "%%display\n%d",
             DisplayHead->type );
    writeComment();
  }

/* Norm */
  if( NormHead != NULL ){
    fprintf( commonfp2, "%%norm\n%d",
             NormHead->type );
    writeComment();
  }

  fclose( commonfp2 );
}

void  writeComment(void)
{
  fprintf( commonfp2, "\n:\n" );
}

/* --- end of common2.c --- */
