#include <stdio.h>
#include "LIB.h"
#include "ex_global_vars.h"

/*********************************************************************
**  Subroutine of Differentiation				    **
**********************************************************************/
double  differentiate(PARAM  *vParam[],
              double *nablaFx, double *direction )
{
  int    i;
  double x, h, f_, Fdash=0.0;

  for( i=0; i<NumVarParam; i++ ) {
    x = vParam[i]->value;
    h = vParam[i]->span;

    vParam[i]->value = x + h;
    f_  = errorFunc( AllParam );  /* f(x+h) */

    vParam[i]->value = x - h;
    f_ -= errorFunc( AllParam );  /* f(x+h)-f(x-h) */

    nablaFx[i] = f_/(2.0*h);      /* f'(x)=(f(x+h)-f(x-h))/2h */

    vParam[i]->value = x;

    if( direction != NULL )
      Fdash += direction[i] * nablaFx[i];
  }
  return( Fdash );
}
