#include <stdio.h>
#include "LIB.h"
#include "NPEcmd.h"
#include "ex_global_vars.h"

#if !defined(WIDTH)
#define  WIDTH    (4)  /* display 4 parameters in each line */
#endif

/*******************************************************************
**  'display()' displays Parameters                               **
********************************************************************/
void  display(PARAM  *param, double  errorValue)
{
  int  i, j;
  struct estparam  *e;

  if(((ModelHead->type == USR)||(ModelHead->type == NCS))&&
     (PenaltyHead != NULL)){
    printf("\n\t<<<  %d Step : Error = %g  Penalty = %g >>>\n\n",
           Step, errorValue, PenaltyValue );
  } else {
    printf("\n\t\t<<<  %d Step : Error = %g  >>>\n\n",
           Step, errorValue );
  }

  e = InitHead->EstParam;

  for( i=0; i<NumAllParam; i+=j ){
    for( j=0; (i+j<NumAllParam) && (j<WIDTH); j++,e=e->next ) {
      printf("%15s ", e->name );
    }
    putchar( '\n' );

    for( j=0; i+j<NumAllParam && j<WIDTH; j++ ) {
      printf("%15g ", getValue( param[i+j] ) );
    }
    putchar( '\n' );
    putchar( '\n' );
  }
  fflush( stdout );
}
