/*******************************************************************
**  There are Library functions that are used by "NCS" model      **
**	*errorFunc	: Error Function for NCS model            **
**	*dataStore	: stores NCS Model Outputs                **
**			  (called by storeParamHist)              **
**	*readParam	: reads Parameters for NCS Model          **
********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "LIB.h"
#include "NPEcmd.h"
#include "ex_global_vars.h"


#if defined(ANSI) /* function of libNPEncs.a(ncssnpe.c) */
extern double *GetPrmPtr(char *mdl_name, char *prm_name);
extern int  ncsxstart1(void);
extern void  ncsReadConditionFile(void);
double  err_norm_one(double *disp);
double  err_norm_two(double *disp);
double  err_norm_inf(double *disp);

#else
extern double *GetPrmPtr();
extern int  ncsxstart1();
extern void  ncsReadConditionFile();
double  err_norm_one();
double  err_norm_two();
double  err_norm_inf();

#endif  /* ANSI */


/* global vars in this file */
double   **NcsParamPtr;
double	**NcsOutput;

/*******************************************************************
**  Error Function                                                **
********************************************************************/
double  err_norm_one(double *disp)
{
  double error = 0.0, tmp;
  int i,t;

  *disp = 0.0;
  for( t=0; t < DataPoint; t++ ) {
    for( i=0; i < NumWave; i++ ) {
      tmp = fabs(WaveData[i][t]-NcsOutput[i][t]);
      error += tmp * WeightData[i][t];
      *disp += tmp;
    }
  }
  return( error );
}


double  err_norm_two(double *disp)
{
  double error = 0.0, tmp;
  int i,t;

  *disp = 0.0;
  for( t=0; t < DataPoint; t++ ) {
    for( i=0; i < NumWave; i++ ) {
      tmp = fabs(WaveData[i][t]-NcsOutput[i][t]);
      error += tmp*tmp * WeightData[i][t];
      *disp += tmp*tmp;
    }
  }
  return( error );
}


double  err_norm_inf(double *disp)
{
  double error = 0.0, tmp, tmperr;
  int i,t;

  *disp = 0.0;
  for( t=0; t < DataPoint; t++ ) {
    for( i=0; i < NumWave; i++ ) {
      tmp = fabs(WaveData[i][t]-NcsOutput[i][t]);
      tmperr = tmp * WeightData[i][t];
      if(error < tmperr){
        error = tmperr;
        *disp = tmp;
      }
    }
  }
  return( error );
}


double  errorFunc(PARAM  *AllParam)
{
  double  error, disp;
  int  i;

  for( i=0 ; i < NumAllParam ; i++ ){
    ModelParam[i] = *NcsParamPtr[i] = getValue( AllParam[i] );
  }

  ncsxstart1();

  switch(NormHead->type){
    case NORM_ONE : error = err_norm_one(&disp);
      break;
    case NORM_TWO : error = err_norm_two(&disp);
      break;
    case NORM_INF : error = err_norm_inf(&disp);
      break;
    default  : error = err_norm_two(&disp);
  }

  if(DisplayHead->type == NO_WEIGHT)
    tmpDisp = disp;
  else
    tmpDisp = error;

  tmpPena = penalty( ModelParam );
  error += tmpPena;
  return( error );
}

/*******************************************************************
**  'dataStore()' stores Model Output                             **
********************************************************************/
void  dataStore(PARAM  *Param)
{
  static float  **output = NULL;
  Buffer   *outbuf;
  int    i, t;
  int   local_index[MAX_INDEX];  
  int   local_index2[MAX_INDEX];  

  if( (ResultHead->fname != NULL ) ||(ResultHead->buffnum > 0) ){
    if( output == NULL ) 
      output  = (float **)malloc2Dim( NumWave, DataPoint, 'F' );

  /*
  ** calculation of model output
  */
    for(i = 0; i < NumAllParam; i++)
      *NcsParamPtr[i] = getValue( AllParam[i] );
  
    ncsxstart1();

    for(t = 0; t < DataPoint; t++)
      for(i = 0; i < NumWave; i++)
        output[i][t] = (float)NcsOutput[i][t];

    local_index[0] = NumWave;
    local_index[1] = DataPoint;
    if( ( outbuf = AllocBuffer( IndexSize( 2, local_index ) )) == NULL ){
          fprintf( stderr, "Memory Allocation Error\n" );
           exit(208);
    }
    for( local_index2[0]=0; local_index2[0]<NumWave; local_index2[0]++ ){
      for(local_index2[1]=0;local_index2[1]<DataPoint; local_index2[1]++){
        outbuf[Index(local_index2,2,local_index)] 
        = output[local_index2[0]][local_index2[1]];
      }
    }

    WriteBuffer( ResultHead->buffnum , 2, local_index , outbuf);
    if( ResultHead->fname != NULL ){
      float *store_data;
      int   dpt;

      dpt = IndexSize( 2, local_index );
      store_data = (float *)malloc(sizeof(float)*dpt);
      if(store_data == NULL){
         fprintf(stderr,"Out of Memory\n");
         exit(1);
      }
      for(i=0; i<dpt; i++)
         store_data[i] = (float)outbuf[i];

      if(WriteFile( ResultHead->fname , 2 , local_index , 
                    (char *)store_data) < 0 ){
        printf("Warrning: WriteFile error < %s >\n", ResultHead->fname);
      }
      free(store_data);
    }
    FreeBuffer( outbuf );
  }
}

/*******************************************************************
**  'readParam()' reads Initial Parameter                         **
********************************************************************/
int  readParam(void)
{
  int  i, j;

  char  *cp, str2[MAXPARAMNAME], str3[MAXPARAMNAME];
  struct estparam  *e;

  extern int data_point;  /* from ~/NCS/lib/ncslib/ncssnpe.c */

  ncsReadConditionFile();

  if( PointHead->datapoint < data_point ){
    fprintf(stderr, "Error: DataPoint is Wrong.  NPE: %d <--> NCS: %d\n",
      PointHead->datapoint, data_point);
    fprintf(stderr,"Abort\n");
    exit(1);
  }
  NumAllParam = InitHead->paramnum;

  if( NumAllParam > UPPER_LIMIT ) {
    exit( 4 );
  }

  NumWave   = NumberHead->numwave;

  /*
  **  allocating array
  */
  AllParam    = (PARAM  *)malloc2Dim( 0, NumAllParam, 'P' );
  ModelParam  = (double *)malloc2Dim( 0, NumAllParam, 'D' );
  NcsParamPtr = (double **)malloc(sizeof(double *)*NumAllParam);
  if( NcsParamPtr == NULL ){
    printf("Error : Out of memory\n");
    exit( 1 );
  }
  NcsOutput   = (double **)malloc2Dim( NumWave, DataPoint, 'D' );

  /*
  **  reading each Parameters
  */
  NumVarParam = 0;
  for( i=0,e=InitHead->EstParam; i<NumAllParam; i++,e=e->next ) { 
    AllParam[i].value = e->value;
    AllParam[i].flag  = e->flag;
    if( AllParam[i].flag == VAR )
      NumVarParam++;
    AllParam[i].scale = 1.0;
    AllParam[i].span  = e->span;
  
    /*
    ** Pointer of Blockdata (SigmaParamPtr)
    */

    cp = strtok( e->name, "@\t " );
    strcpy( str3, cp );
    cp = strtok( NULL, "\n" );
    strcpy( str2, cp );

    if( (NcsParamPtr[i] = GetPrmPtr( str2, str3 )) == NULL ) exit( 57 );

    strcpy( e->name, str2 );
    strcat( e->name, " " );
    strcat( e->name, str3 );
  }

  /*
  **  setting Variable Parameters
  */
  VarParam = (PARAM **)malloc(sizeof(PARAM *)*NumVarParam);
  if(VarParam == NULL) exit( 1 );

  for( i=j=0; i<NumAllParam; i++ ) {
    if( AllParam[i].flag == VAR ) {
      VarParam[j++] = &AllParam[i];
    }
  }
 return(0);
}
