/********************************************************************
**  There are Library functions that are used by "USR" Model(C)    **
**  *errorFunc  : Error Function for Least Square                  **
**  *dataStore  : stores C Model Outputs                           **
**                (called by storeParamHist)                       **
********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "LIB.h"
#include "NPEcmd.h"
#include "ex_global_vars.h"

#if defined(ANSI)
/* User defined Model Function */
extern int  model(int t, double *parm, double *output);
double  err_norm_one(PARAM *AllParam, double *disp);
double  err_norm_tow(PARAM *AllParam, double *disp);
double  err_norm_inf(PARAM *AllParam, double *disp);

#else /* traditional */
extern int  model();
double  err_norm_one();
double  err_norm_two();
double  err_norm_inf();

#endif /* ANSI */


/*******************************************************************
**  Error Function                                                **
********************************************************************/
double  errorFunc(PARAM  *AllParam)
{
  double  error, disp;

  switch(NormHead->type){
    case NORM_ONE : error = err_norm_one(AllParam, &disp);
      break;
    case NORM_TWO : error = err_norm_tow(AllParam, &disp);
      break;
    case NORM_INF : error = err_norm_inf(AllParam, &disp);
      break;
    default  : error = err_norm_tow(AllParam, &disp);
  }


  if(DisplayHead->type == NO_WEIGHT)
    tmpDisp = disp;
  else
    tmpDisp = error;

  tmpPena = penalty( ModelParam );
  error += tmpPena;
  return( error );
}


double  err_norm_tow(PARAM *AllParam, double *disp)
{
  double  error = 0.0,tmp;
  int  i, t;

  *disp = 0.0;
  for( i=0; i < NumAllParam; i++ )
    ModelParam[i] = getValue( AllParam[i] );

  for( t=0; t < DataPoint; t++ ) {
    model( t, ModelParam, Output );
    for( i=0; i < NumWave; i++ ) {
      tmp = WaveData[i][t]-Output[i];
      error += square(tmp)* WeightData[i][t];
      *disp  += square(tmp);
    }
  }
  return(error);
}


double  err_norm_one(PARAM *AllParam, double *disp)
{
  double  error = 0.0,tmp;
  int  i, t;

  *disp = 0.0;
  for( i=0; i < NumAllParam; i++ )
    ModelParam[i] = getValue( AllParam[i] );

  for( t=0; t < DataPoint; t++ ) {
    model( t, ModelParam, Output );
    for( i=0; i < NumWave; i++ ) {
      tmp = fabs(WaveData[i][t]-Output[i]);
      error += tmp* WeightData[i][t];
      *disp  += tmp;
    }
  }
  return(error);
}


double  err_norm_inf(PARAM *AllParam, double *disp)
{
  double  error = 0.0,tmp, tmperr;
  int  i, t;

  *disp = 0.0;
  for( i=0; i < NumAllParam; i++ )
    ModelParam[i] = getValue( AllParam[i] );

  for( t=0; t < DataPoint; t++ ) {
    model( t, ModelParam, Output );
    for( i=0; i < NumWave; i++ ) {
      tmp = fabs(WaveData[i][t]-Output[i]);
      tmperr = tmp*WeightData[i][t];
      if( error < tmperr ){
        error = tmperr;
        *disp  = tmp;
      }
    }
  }
  return(error);
}

/*******************************************************************
**  'dataStore()' stores Model Output                             **
********************************************************************/
void  dataStore( PARAM  *Param )
{

  int    i, t, dpt;
  int     Dimension, local_index[MAX_INDEX];
  Buffer  *output;
  float   *ResultFloat;

  if( ResultHead->fname == NULL && ResultHead->buffnum <= 0 )
    exit( 410 );

  Dimension = 2;
  local_index[0] = DataPoint;
  local_index[1] = NumWave;

  output = AllocBuffer(IndexSize(Dimension, local_index));
  if( output == NULL ) exit( 1 );

  /*
  ** calculation of model output
  */
  for(i = 0; i < NumAllParam; i++){
      ModelParam[i] = (double)getValue( Param[i] );
  }

  dpt = 0;
  for(t = 0; t < DataPoint; t++){
    model(t, ModelParam, Output);
    for(i = 0; i < NumWave; i++){
      output[dpt+i] = (double)Output[i];
    }
    dpt += NumWave;
  }

  WriteBuffer(ResultHead->buffnum, Dimension, local_index, output);

  dpt = IndexSize(Dimension, local_index);
  ResultFloat = (float *)malloc(dpt*sizeof(float));

  for ( i=0 ; i < dpt ; i++){
    ResultFloat[i] = (float)output[i];
  }
  if(WriteFile(ResultHead->fname, Dimension,
      local_index, (char *)ResultFloat) < 0) {
    printf("Warrning: WriteFile error < %s >\n", ResultHead->fname);
  }
  free(ResultFloat);
  FreeBuffer(output);
}
