/**************************************************
**  malloc.c --- Memory Allocation Function	 **
**************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "LIB.h"

void	*malloc2Dim _ANSI_ARGS_((int m,int n, int types));

/*******************************************************************
**  'malloc2Dim()' allocates 2 dimensional array                  **
********************************************************************/
void *
malloc2Dim(m, n, types)
     int  m;
     int  n;
     int  types;
{
  int	i, j;
  void	 **dim  = NULL;
  int    **iptr = NULL;
  float  **fptr = NULL;
  double **dptr = NULL;
  PARAM  **Pptr = NULL;

  if( n <= 0 || m < 0 ) return NULL;

  j = ( m == 0 ) ? 1 : m;

  switch( types ){
  case 'I': 
    iptr = (int **)malloc( j * sizeof(int *) );
    if(iptr == NULL)  exit( 1 );
    dim = (void **)iptr;
    break;
  case 'F':
    fptr = (float **)malloc( j * sizeof(float *) );
    if( fptr == NULL )  exit( 1 );
    dim = (void **)fptr;
    break;
  case 'D':
    dptr = (double **)malloc( j * sizeof(double *) );
    if( dptr == NULL ) exit( 1 );
    dim = (void **)dptr;
    break;
  case 'P':
    Pptr = (PARAM **)malloc( j * sizeof(PARAM *) );
    if( Pptr == NULL ) exit( 1 );
    dim = (void **)Pptr;
    break;
  default :
    exit( 100 );	/* Unknown type */
  }

  for( i = 0; i < j; i++){
    switch( types ){
    case 'I':
      iptr[i] = (int *)calloc( n, sizeof( int ) );
      if( iptr[i] == NULL ) exit( 1 );
      break;
      break;
    case 'F':
      fptr[i] = (float *)calloc( n, sizeof( float ) );
      if( fptr[i] == NULL ) exit( 1 );
      break;
    case 'D':
      dptr[i] = (double *)calloc( n, sizeof( double ) );
      if( dptr[i] == NULL ) exit( 1 );
      break;
    case 'P':
      Pptr[i] = (PARAM *)calloc( n, sizeof( PARAM ) );
      if( Pptr[i] == NULL ) exit( 1 );
      break;
    default:
      exit( 100 ); /* Unknown type */
    }
  }

  return (m == 0) ? dim[0] : dim;
}
