/**************************************************
**  param.c --- Parameter Information reader	 **
**************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "LIB.h"
#include "NPEcmd.h"
#include "ex_global_vars.h"

/******************************************************************
**  'readParam()' reads Initial Parameter                        **
******************************************************************/
int  readParam(void)
{
  int    i, j;
  struct estparam  *e;

  NumAllParam = InitHead->paramnum;
  if( NumAllParam > UPPER_LIMIT ) exit( 4 );

  /*
  **  allocating array
  */
  AllParam   = (PARAM  *)malloc2Dim( 0, NumAllParam, 'P' );
  ModelParam = (double *)malloc2Dim( 0, NumAllParam, 'D' );

  /*
  **  copying each Parameters
  */
  NumVarParam = 0;
  for( i=0,e=InitHead->EstParam; i<NumAllParam; i++,e=e->next ) { 
    AllParam[i].value = e->value;
    AllParam[i].flag  = e->flag;
    if( AllParam[i].flag == VAR )
      NumVarParam++;
    AllParam[i].scale = 1.0;
    AllParam[i].span  = e->span;
  }
  
  /*
  **  setting Variable Parameters
  */
  VarParam = (PARAM **)malloc(sizeof(PARAM *)*NumVarParam);
  if(VarParam == NULL) exit( 1 );

  for( i=j=0; i<NumAllParam; i++ ) {
    if( AllParam[i].flag == VAR ) {
      VarParam[j++] = &AllParam[i];
    }
  }
  return(0);
}










