/*************************************************
**  read.c --- Reading Functions of NPE		**
*************************************************/

#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "LIB.h"
#include "NPEcmd.h"
#include "ex_global_vars.h"

#define	DEFAULTDATAPOINT	(1024)
#define	absolute(a)		((a<0.0)?(-a):(a))

/* global vars */
uint     MaxHistoryPoint;
double  *ParamHist;
Header   head;

/*******************************************************************
**  'readScaleMethod()' reads Scaling Method                      **
*******************************************************************/
void
readScaleMethod(void)
{
  ScaleMethod = ScaleHead->scalemethod;
  if( ScaleMethod > 3)  /* ScaleMethod is unisiged int ! */
    exit( 156 );
}

/*******************************************************************
**  'readStoreFile()' reads File Name for  Model Output &         **
**                                         Parameter Histry       **
*******************************************************************/
int
readStoreFile(void)
{
  uint  i;
  struct termcrite *tc;

  if (HistoryHead == NULL ) return -1;
  StoreInterval = absolute( HistoryHead->storeinterval );

  for (tc = TermHead->TermCrite; tc != NULL; tc = tc->next) {
    if (tc->critenum == 0) break;
  }

  if ( tc == NULL ) MaxHistoryPoint = DEFAULTDATAPOINT;
  else              MaxHistoryPoint = tc->critevalue;

  MaxHistoryPoint = MaxHistoryPoint/StoreInterval +1
        +(((MaxHistoryPoint%StoreInterval)==0)?(0):(1));

  if( HistoryHead->fname != NULL || HistoryHead->buffnum > 0 ) {
    read_syscom();
    ParamHist = AllocBuffer(MaxHistoryPoint);
    write_syscom();
  }
  for( i=0; i<MaxHistoryPoint; i++ )
    ParamHist[i] = 0.0;
  
  if( HistoryHead->fname != NULL ) InitHeader( &head ); 

  if( ResultHead == NULL ) return -1;
  if( ResultHead->fname != NULL ) InitHeader( &head ); 

  return 0;
}

/*******************************************************************
**  'readSystemParam()' reads System Parameter                    **
*******************************************************************/
void
readSystemParam(double *samp)
{
  read_syscom();
  *samp = syscom.sam_freq;
}
