/*************************************************
**  read2.c --- Data Reading Function		**
**              from data and weight files      **
*************************************************/
#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "LIB.h"
#include "NPEcmd.h"
#include "ex_global_vars.h"

/*******************************************************************
**  'readData()' reads object data & weight data                  **
*******************************************************************/
#if defined(ANSI)
void  dataLoad(double **data, char *fname, int recNum );

#else  /* traditional */
void  dataLoad();

#endif

#if !defined(_Tmp_File_Size_)
#define _Tmp_File_Size_  MAXLINE
#endif


void  readData(void)
{
  /* set the data point */
  DataPoint = PointHead->datapoint;
  NumWave   = NumberHead->numwave;
  if( NumWave > UPPER_LIMIT ) {
    exit( 101 );
  }
  Output    = (double *)malloc2Dim( 0, NumWave, 'D' );

  /* load a output data */
  WaveData = (double **)malloc2Dim( NumWave, DataPoint, 'D' );
  dataLoad( WaveData, ExperimentHead->fname, ExperimentHead->recnum );

  /* load a weight data */
  WeightData = (double **)malloc2Dim( NumWave, DataPoint, 'D' );
  dataLoad( WeightData, WeightHead->fname, WeightHead->recnum );
}


void  dataLoad(double **data, char *fname, int recNum )
{
  int  i, j, ch;
  Header  head;
  char   *cdumWave;
  float  *fdumWave;
  double *ddumWave;

  /* The file is exist? */
  if( LoadHeader( fname, &head )<0 ){
    printf("Error: Can't open < %s >.\n",fname);
    exit( 0 );  /* 2: File Not Exist */
  }

  /* check the file size */
  if(head.index[1] < DataPoint ){
    printf("Error: Illegal data point.\n");
    exit( 0 );
  }

  switch( (int)(head.data_size) ){
    case 2 :
      printf("\n[Warring] < %s > is 2 byte size file.\n", fname);
      printf("Realy do you use this file ? (y/n) ");
      rewind(stdin);
      ch = getc(stdin);
      rewind(stdin);
      if( (ch != 'y')&&(ch != 'Y')) exit( 62 );
      for( i=recNum; i<(NumWave+recNum); i++ ) {
        cdumWave = (char *)LoadData(fname, i, &head );
        for( j=0; j<DataPoint; j++ )
          data[i][j] = (double)cdumWave[j];
        free( cdumWave );
      }
      break;
    case 4 :
      for( i=recNum; i<(NumWave+recNum); i++ ) {
        fdumWave = (float *)LoadData(fname, i, &head );
        for( j=0; j<DataPoint; j++ )
          data[i][j] = (double)fdumWave[j];
        free( fdumWave );
      }
      break;
    case 8 :
      for( i=recNum; i<(NumWave+recNum); i++ ) {
        ddumWave = (double *)LoadData(fname, i, &head );
        for( j=0; j<DataPoint; j++ )
        data[i][j] = ddumWave[j];
        free( ddumWave );
      }
      break;
    default : exit( 400 );
  }
}
