/*************************************************
** scale.c --- Scaling Functions		**
*************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "LIB.h"

/*******************************************************************
** Scale Transformation subroutine                                **
*******************************************************************/
int  scaleTrans(PARAM  **varParam );
void  scaleTrans10(PARAM  **varParam );
void  scaleTrans1(PARAM  **varParam );


int  scaleTrans(PARAM  **varParam )
{

  switch( ScaleMethod ) {
    case 1 : /* Execute scaling at the first time ONLY */
     if( Step != 0 ) return(0);
    case 2 :
      scaleTrans10( varParam );
      break;
    case 3 : /* Re-scaling */
      scaleTrans1( varParam );
      break;
    case 0 : /* scaling off */
    default: return(0);
  }
  return(0);
}


void  scaleTrans10(PARAM  **varParam )
{
  int  i;

  for( i=0; i<NumVarParam; i++ ) {
    if( (varParam[i]->value >= 10.)||(varParam[i]->value <= -10.) ){
      while( (varParam[i]->value >= 10.)||(varParam[i]->value <= -10.) ){
        varParam[i]->value /= 10.;
        varParam[i]->scale *= 10.;
      }
    } else if( (varParam[i]->value < 1.)&&(varParam[i]->value > -1.) ){
       while( (varParam[i]->value < 1.)&&(varParam[i]->value > -1.) ){
         varParam[i]->value *= 10.;
         varParam[i]->scale /= 10.;
       }
    }
  }
}

/* Re-scaling */
void  scaleTrans1(PARAM  **varParam )
{
  int  i;

  for( i=0; i<NumVarParam; i++ ) {
    varParam[i]->scale *= varParam[i]->value;
    varParam[i]->value  = 1.0;
  }
}
