#include <stdio.h>
#include "LIB.h"

/*********************************************************************
**  Subroutine of Differentiation				    **
*********************************************************************/
void  secondDifferential(PARAM  *vParam[], double  **Hess);

void  secondDifferential(PARAM  *vParam[], double  **Hess)
{
  int     i, j;
  double  xi, xj, hi, hj, f_;

  f_=0.0;
  for( i=0; i<NumVarParam; i++ ) {
    xi = vParam[i]->value;
    hi = vParam[i]->span; 
    for( j=0; j<=i; j++ ){ 
      xj = vParam[j]->value;
      hj = vParam[j]->span; 
      if( i!=j ){                        /* calculate df/dxdy */

        vParam[i]->value = xi + hi;
        vParam[j]->value = xj + hj;
        f_  = errorFunc( AllParam );     /* f(xi+hi,x2+hj)*/

        vParam[i]->value = xi - hi;
        vParam[j]->value = xj + hj;
        f_ -= errorFunc( AllParam );     /* -f(xi-hi,x2+hj)*/

        vParam[i]->value = xi + hi;
        vParam[j]->value = xj - hj;
        f_ -= errorFunc( AllParam );     /* -f(xi+hi,x2-hj)*/

        vParam[i]->value = xi - hi;
        vParam[j]->value = xj - hj;
        f_ += errorFunc( AllParam );     /* +f(xi-hi,x2-hj)*/

        Hess[i][j] = f_/(4.0*hi*hj);     /* f''(x)=f_ /(4*hi*hj) */


      }else{                             /* calculate df/dx^2 */

        f_ =-2.0*errorFunc( AllParam );  /* -2*f(xi,x2)*/

        vParam[i]->value = xi + hi;
        f_ += errorFunc( AllParam );     /* +f(xi+hi,x2)*/
      
        vParam[i]->value = xi - hi;
        f_ += errorFunc( AllParam );     /* +f(xi-hi,x2)*/

        Hess[i][j] = f_/(hi*hi);         /* f''(x)=f_ /hi^2 */
      }
      fflush( (FILE *)stdout );
      vParam[i]->value = xi;
      vParam[j]->value = xj;
      Hess[j][i]=Hess[i][j];
    }
  }

}
