#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "NPE.h"
#include "NPEcmd.h"
#include "global_vars.h"

#define MAXITERATION	(10000)

double  **Hessian, *Dif_x, *Dif_nabla, *v_k, *H_Dif_nabla;  /* for Hessian */
double  *nablaF, *Direction;              /* nabla f(x) & Direction vector */

/* function prototypes */
#if defined(ANSI)
void  quasiNewtonInit(void);
void  initHessian(double  **Hesse);
void  calcDirection(void);
BOOL  checkDescentDir(void);
BOOL  overRestart( int count );
void  linearSearch(void);
void  renewHessian(void);
void  StoreBuffID(int ResultBuffID, int HistoryBuffID );
void  renpe_(char *filename);
void  initHead(void);
void  free_quasi_Newton(void);

#else /* traditional */
void  quasiNewtonInit();
void  initHessian();
void  calcDirection(void);
BOOL  checkDescentDir();
BOOL  overRestart();
void  linearSearch();
void  renewHessian();
void  StoreBuffID();
void  renpe_();
void  initHead();
void  free_quasi_Newton();

#endif /* ANSI */

/*********************************************************************
**  Main routine of quasi-Newton Method                             **
*********************************************************************/
int main(int argc, char **argv )
{
  void  cleanUp(char **argv);
  int  restartCount=0;
  double  Old_ErrorVal;
  int     ResultBuffID , HistoryBuffID;


  if(argc < 4 ){
    printf("Error too few argument\n");
    exit(1);
  }

  renpe_( argv[1] );

  ResultBuffID = atoi(argv[2]);
  HistoryBuffID = atoi(argv[3]);
  StoreBuffID(ResultBuffID , HistoryBuffID);

  /* start up message */
  printf("[ NPE ] SSVM \n");
  fflush(stdout);


  quasiNewtonInit();
  Old_ErrorVal = ErrorValue;

  for( Step=0; Step < MAXITERATION; Step++ ) {

    display( AllParam, DispValue );

    storeParamHist( AllParam, FALSE );

    if( term() ) break;

    scaleTrans( VarParam );

    calcDirection();
    if( (!(checkDescentDir()))||(Old_ErrorVal<ErrorValue) ){
      fprintf(stderr,"I seem Hess matrix is not positive define...\n");
      fprintf(stderr,"Initilize Hess matrix\n");
      for( restartCount=0; ; restartCount++ ) {
        initHessian( Hessian );
        calcDirection();
        if( checkDescentDir() ) break;

        if( overRestart(restartCount) ) {
          storeParamHist( AllParam, TRUE );
          cleanUp( argv );
          initHead();
          free_quasi_Newton();
          return( 5 );
        }
      }
    }
    Old_ErrorVal = ErrorValue;
    linearSearch();
    renewHessian();
  }
  storeParamHist( AllParam, TRUE );
  cleanUp( argv );
  initHead();
  free_quasi_Newton();
  return( 0 );
}

/*********************************************************************
**  Subroutine of Initializition                                    **
*********************************************************************/
void  quasiNewtonInit(void)
{

  readData();
  readParam();
  readTermCriterion();
  readSystemParam( &samp );
  readStoreFile();
  readScaleMethod();

  Hessian   = (double **)malloc2Dim( NumVarParam, NumVarParam, 'D' );
  nablaF    = (double *) malloc2Dim( 0, NumVarParam, 'D' );
  Dif_x     = (double *) malloc2Dim( 0, NumVarParam, 'D' );
  Dif_nabla     = (double *) malloc2Dim( 0, NumVarParam, 'D' );
  v_k     = (double *) malloc2Dim( 0, NumVarParam, 'D' );
  H_Dif_nabla    = (double *) malloc2Dim( 0, NumVarParam, 'D' );
  Direction = (double *) malloc2Dim( 0, NumVarParam, 'D' );

  ErrorValue = errorFunc( AllParam );
  DispValue = tmpDisp;
  PenaltyValue = tmpPena;
  differentiate( VarParam, nablaF, NULL );
  initHessian( Hessian );
}


void free_quasi_Newton(void)
{
  int i;

  for(i=0; i< NumVarParam; i++)
    free( Hessian[i] );
  free( Hessian );
  free( nablaF );
  free( Dif_x );
  free( Dif_nabla );
  free( v_k );
  free( Direction );
  free( H_Dif_nabla );
}

/*********************************************************************
**  Subroutine of Initializition of Hessian                         **
*********************************************************************/
void  initHessian(double  **Hesse)
{
  int  i, j;

  for( i=0; i<NumVarParam; i++ ) {
    for( j=0; j<NumVarParam; j++ ) {
      Hesse[i][j] = 0.0;
    }
  }
  for( i=0; i<NumVarParam; i++ )
    Hesse[i][i] = 1.0;
}

/*********************************************************************
**  Subroutine of Calculation of Direction                          **
*********************************************************************/
void  calcDirection(void)
{
  int  i, j;
  double  D;

  D = 0.0;
  for( i=0; i<NumVarParam; i++ ) {
    Direction[i] = 0.0;
    for( j=0; j<NumVarParam; j++ )
      Direction[i] -= Hessian[i][j] * nablaF[j];

    D += Direction[i]*Direction[i];
  }

  if( D != 0.0 ){
    D = 1.0/sqrt( D );
    for( i=0; i<NumVarParam; i++ )
      Direction[i] *= D;
  }
}

/*********************************************************************
**  Subroutine of Checking Descent Direction                        **
*********************************************************************/
BOOL  checkDescentDir(void)
{
  int  i;
  double  D_ = 0.0;

  for( i=0; i<NumVarParam; i++ )
    D_ += nablaF[i] * Direction[i];

  if( D_ < 0.0 )  return( TRUE  );
  return( FALSE );
}

/*********************************************************************
**  Subroutine of Checking Number of Restart                        **
*********************************************************************/
BOOL  overRestart(int count )
{
/*  extern double  criterionValue[]; */

  if( count >= 3 ) return( TRUE  );
  return( FALSE );
}

/*********************************************************************
**  Subroutine of LinearSearch                                      **
**********************************************************************/
void  linearSearch(void)
{
  int  i;
  double norm, norm2;

  for( i=0; i<NumVarParam; i++ ) {
    Dif_x[i] = -VarParam[i]->value;  /* s = Xk+1-Xk       */
    Dif_nabla[i] = -nablaF[i];       /* y=dF(Xk+1)-dF(Xk) */
  }

  interpolation();
  DispValue = tmpDisp;
  PenaltyValue = tmpPena;

/* calculate with new parameter */
  differentiate( VarParam, nablaF, NULL );

  norm = 0.0; norm2 = 0.0;
  for( i=0; i<NumVarParam; i++ ) {
    Dif_x[i] += VarParam[i]->value; /* s = Xk+1-Xk      */
    Dif_nabla[i] += nablaF[i];      /* y=dF(Xk+1)-dF(Xk) */
    norm += Dif_nabla[i]*Dif_nabla[i];
    norm2 += Dif_x[i]*Dif_x[i];
  }
  if(norm*norm2 == 0.0){
    fprintf(stderr,"Too few changes... I can't update Hess Matrix\n");
    fprintf(stderr,"I guess the estimation is done. Now storing results\n"); 
    storeParamHist( AllParam, TRUE );
    initHead();
    free_quasi_Newton();
    exit(0);
  }
}

/********************************************************************
*  Subroutine of Calculation of Hessian : DFP(Self-Scaling)      *
*                    *
*                       Hy * yH           >s,s<  *
*  Hess   =  omega{ H - -------- + ita*<y,Hy>* >v,v< }+ -----  *
*                        <y,Hy>                 <s,y>  *
*          <s,y>      <s,g>        *
*  omega  =  (1-fai) * ------ + fai * -------        *
*          <y,Hy>      <g,Hy>        *
*      <s,y>     s                *
*  v = ----- - -----  0<=ita,fai<=1           *
*      <y,Hy>  <s,y>              *
*                    *
********************************************************************/
void  renewHessian(void)
{
  int  i, j;
  double  ita, omega, fai;
  double  cof1, cof2, yHy, sy, gHy, sg;

  ita = 0.7; fai = 0.3;

/*-------------------------------------------------------------
  yHy = <y,Hy>  ,  sy = <s,y>
  cof1 = 1/yHy  ,  cof2 = 1/sy
--------------------------------------------------------------*/
  yHy = 0.0;
  for( i=0; i<NumVarParam; i++ ) {
    H_Dif_nabla[i] = 0.0;
    for( j=0; j<NumVarParam; j++ )
      H_Dif_nabla[i] += Hessian[i][j]*Dif_nabla[j];

    yHy += Dif_nabla[i]*H_Dif_nabla[i];
  }
  sy=0.0;
  for( i=0; i<NumVarParam; i++ )
    sy += Dif_x[i]*Dif_nabla[i] ;

  cof1 = 1.0/yHy;
  cof2 = 1.0/sy;

/*-------------------------------------------------------------
  omega  =  (1-fai)*cof*<s,y> + fai*<s,g>/<g.Hy>
-------------------------------------------------------------*/
  gHy = 0.0;
  for( i=0; i<NumVarParam; i++ )
    gHy += nablaF[i]*H_Dif_nabla[i];

  sg = 0.0;
  for( i=0; i<NumVarParam; i++ ) {
    sg += Dif_x[i]*nablaF[i];
  }
  omega = (1.0 - fai)*cof1*sy + fai*sg/gHy;


/*-------------------------------------------------------------
  v = cof1*<s,y> - cof2*s  
--------------------------------------------------------------*/
  for( i=0; i<NumVarParam; i++ )
    v_k[i] = cof1*H_Dif_nabla[i] - cof2*Dif_x[i] ;

/*-------------------------------------------------------------
  Hess   =  omega{ H - cof1*(Hy * yH) + ita*yHy* >v,v< }
      + cof2 * >s,s<  
-------------------------------------------------------------*/


  for( i=0; i<NumVarParam; i++ ){
    for( j=0; j<i; j++ ) {
      Hessian[i][j] = omega*( 
            Hessian[i][j] - cof1*H_Dif_nabla[i]*H_Dif_nabla[j]
          + ita*yHy*v_k[i]*v_k[j]
        )      + cof2*Dif_x[i]*Dif_x[j]; 
      Hessian[j][i] = Hessian[i][j];
    }
  }

}

void  StoreBuffID(int ResultBuffID , int HistoryBuffID )
{
  Result *wRe;        /* work */
  History *wHis;      /* work */


  for( wRe = ResultHead ; wRe != NULL ; wRe = wRe->next )
      wRe->buffnum = ResultBuffID;



  for( wHis = HistoryHead ; wHis != NULL ; wHis = wHis->next )
      wHis->buffnum = HistoryBuffID;
}
