/*************************************************
**  store.c --- Store routine			**
**************************************************/

/*******************************************************************
**  storeParamHist	: stores Parameters & Model(C) Outputs    **
*******************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "LIB.h"
#include "NPEcmd.h"
#include "ex_global_vars.h"

extern uint  MaxHistoryPoint;

/*******************************************************************
**  'storeParamHist()' stores Parameter                           **
*******************************************************************/
int  storeParamHist (PARAM  *Param, int finalFlag );


int  storeParamHist(PARAM  *Param, int finalFlag )
{
  uint  i;
  int   HistSubBufDim, HistsubBufInd[MAX_INDEX];
  int Dim , index[MAX_INDEX];
  static uint dataPointNum=1;
  Buffer *ParamHist;
  Buffer *CAllocBuffer();
  static int FirstStore = TRUE;
  int  lindex[MAX_INDEX];
  float  *outhist;

  if( finalFlag == TRUE ) {
    printf( "\t%d points are stored in \"%s\"\n",
            dataPointNum, HistoryHead->fname );
  }

  if( finalFlag == TRUE || (Step%StoreInterval) == 0 ) {
      read_syscom();
    if( HistoryHead->buffnum > 0 ) {
      ParamHist = CAllocBuffer(NumAllParam+1);

      for (i=0 ; i < NumAllParam ; i++)
        ParamHist[i] = (double)getValue( Param[i] );
      /* write error at the end of the each history */
      DispValue = tmpDisp;
      ParamHist[NumAllParam] = DispValue;

      HistSubBufDim = 2;
      HistsubBufInd[0]=1;
      HistsubBufInd[1]=NumAllParam+1;
      /* first write */
      if( FirstStore == TRUE ){
        InitBuffer(HistoryHead->buffnum ,     /* buffer ID */
        HistSubBufDim ,                       /* buffer dimesion */
        HistsubBufInd );                      /* buffer index */
        WriteSubBuffer(HistoryHead->buffnum , /* buffer ID */
                       0 ,                    /* store time */
                       HistSubBufDim,         /* buffer dimension */
                       HistsubBufInd,ParamHist);

      }else{
        AppendBuffer(HistoryHead->buffnum ,   /* buffer ID */
                     HistSubBufDim,           /* buffer dimension */
                     HistsubBufInd ,          /* buffer index */
                     ParamHist);              /* store data */
      }

      write_syscom();
      FreeBuffer( ParamHist );
  }

  /* write the history file  */
  if( HistoryHead->fname != NULL ) {
    read_syscom();
    ParamHist = (Buffer *)ReadBuffer(HistoryHead->buffnum,
                                     &Dim, index);

    outhist = (float *)malloc(
                (IndexSize(Dim,index)+1) * (sizeof(float)) );

    for( lindex[0] = 0; lindex[0] < index[0]; lindex[0]++){
       for( lindex[1] = 0; lindex[1] < index[1]; lindex[1]++){
         outhist[ Index(lindex,Dim, index )] 
           = (float)ParamHist[ Index(lindex,Dim,index )];
       }
    }

    if(WriteFile(HistoryHead->fname, Dim, index, (char*)outhist) < 0)
      printf("Warrning: WriteFile error < %s >\n", HistoryHead->fname);

    free( outhist );
    FreeBuffer( ParamHist );
    write_syscom();
  }

  if( HistoryHead->storeinterval >= 0 )
    dataPointNum++;
  }
  if( finalFlag == TRUE ) { 
    dataStore( Param );
    write_syscom();
  }
  FirstStore=FALSE;

  return 0;
}
