/*************************************************
**  term.c --- Terminate Functions & Criterions	**
*************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "LIB.h"
#include "NPEcmd.h"
#include "ex_global_vars.h"
#include "term.h"

void  setGrammer          _ANSI_ARGS_((void));
void  setTable            _ANSI_ARGS_((void));
int   parse               _ANSI_ARGS_((void));
int   readTermCriteIDNum  _ANSI_ARGS_((struct termcrite *t));
int   where               _ANSI_ARGS_((char  *str));
void  push                _ANSI_ARGS_((int state, Node *node));
void  pop                 _ANSI_ARGS_((void));
BOOL  is_token            _ANSI_ARGS_((int c));
void  get_token           _ANSI_ARGS_((char *str, char *sym));
BOOL  term                _ANSI_ARGS_((void));
BOOL  termCheck           _ANSI_ARGS_((int term));

BOOL  term0               _ANSI_ARGS_((void));
BOOL  term1               _ANSI_ARGS_((void));
BOOL  term9               _ANSI_ARGS_((void));
void  getTermMessage      _ANSI_ARGS_((int id, int valType, int ival, 
				       double dval, char *sval, char *ret));
/* puts message both stdout & header of file */
void  putTermMessage      _ANSI_ARGS_((int id, int valType, int ival,
				       double dval, char *sval ));


/*******************************************************************
**  'readTermCriterion()' reads terminate criterions              **
*******************************************************************/
int  readTermCriterion(void)
{
  int  i, num, criteNum;
  struct termcrite *t;

  strcpy( input, TermHead->logic );
  setGrammer();
  setTable();
  criteNum = parse();

  if( criteNum == -1 ) {
    exit( 157 );
  }

  for( i=0,t=TermHead->TermCrite; i<criteNum; i++,t=t->next ) {
    num = readTermCriteIDNum( t );

    if( t->critevalue == -1. ) return( -1 );
    
    criterionValue[num] = t->critevalue; /* gloval vars */
  }
  return( 0 );
}

int  readTermCriteIDNum(struct termcrite *t)
{
  int  ret;

  ret = t->critenum; 
  if( ret < 0 ||  9 < ret ) {
    exit( 158 );
  }
  return( ret );
}

void  setGrammer(void)
{
  int  i;
  
  /***********************
  ** Initializing array **
  ************************/

  for( i=0; i<MAXGRAMMER; i++ ) {
    Grm[i].non_term = NULL;
    Grm[i].terms    = NULL;
    Grm[i].len_sym  = 0;
  }
  for( i=0; i<MAXSTACK; i++ ) {
    Stck[i].node = NULL;
    Stck[i].state = 0;
  }
  for( i=0; i<MAXCRITERION; i++ ) {
    criterionValue[i] = (double)0;
  }
  /**************************
  ** Setting Grammer Table **
  ***************************/

  Grm[0].non_term = (char *)malloc( 6*sizeof(char) );

  if( Grm[0].non_term == NULL ) exit( 1 );

  for(i=1;i<MAXGRAMMER;i++){
    Grm[i].non_term = (char *)malloc( 2*sizeof(char) );
    if( Grm[i].non_term == NULL ) exit( 1 );
  }
  strcpy( Grm[0].non_term, "START" );
  strcpy( Grm[1].non_term,   "E"   );
  strcpy( Grm[2].non_term,   "E"   );
  strcpy( Grm[3].non_term,   "T"   );
  strcpy( Grm[4].non_term,   "T"   );
  strcpy( Grm[5].non_term,   "F"   );
  strcpy( Grm[6].non_term,   "F"   );

  Grm[0].terms = (char *)malloc( 2*sizeof(char) );
  Grm[1].terms = (char *)malloc( 6*sizeof(char) );
  Grm[2].terms = (char *)malloc( 2*sizeof(char) );
  Grm[3].terms = (char *)malloc( 6*sizeof(char) );
  Grm[4].terms = (char *)malloc( 2*sizeof(char) );
  Grm[5].terms = (char *)malloc( 6*sizeof(char) );
  Grm[6].terms = (char *)malloc( 2*sizeof(char) );

  strcpy( Grm[0].terms, "E"     );  /* START -> E      */
  strcpy( Grm[1].terms, "E | T" );  /* E     -> E | T  */
  strcpy( Grm[2].terms, "T"     );  /* E     -> T      */
  strcpy( Grm[3].terms, "T & F" );  /* T     -> T & F  */
  strcpy( Grm[4].terms, "F"     );  /* T     -> F      */
  strcpy( Grm[5].terms, "( E )" );  /* F     -> ( E )  */
  strcpy( Grm[6].terms, "*"     );  /* F     -> number */
  Grm[0].len_sym = 1;
  Grm[1].len_sym = 3;
  Grm[2].len_sym = 1;
  Grm[3].len_sym = 3;
  Grm[4].len_sym = 1;
  Grm[5].len_sym = 3;
  Grm[6].len_sym = 1;
}


void  setTable(void)
{
  int  i, j, len;

  len = N_TERMS+N_NON_T+1;

  for( i=0; i < N_STATE; i++ ) {
    for( j=0; j < len; j++ ) {
      Table[i][j].act = 'n';
      Table[i][j].num = -1;
    }
  }
  /**************************
  ** Setting Parsing Table **
  ***************************
  +----+-----------------------------------+-----------------------+
  |    |   |     &     (     )  *term    $ |  START  E     T     F |   
  +----+-----------------------------------+-----------------------+
  | 0: |             s 4         s 5       |         1     2     3 |
  | 1: | s 6                           acc |                       |
  | 2: | r 2   s 7         r 2         r 2 |                       |
  | 3: | r 4   r 4         r 4         r 4 |                       |
  | 4: |             s 4         s 5       |         8     2     3 |
  | 5: | r 6   r 6         r 6         r 6 |                       |
  | 6: |             s 4         s 5       |               9     3 |
  | 7: |             s 4         s 5       |                    10 |
  | 8: | s 6               s11             |                       |
  | 9: | r 1   s 7         r 1         r 1 |                       |
  |10: | r 3   r 3         r 3         r 3 |                       |
  |11: | r 5   r 5         r 5         r 5 |                       |
  +----+-----------------------------------+-----------------------*/
  Table[0][2].act = 's';   Table[0][2].num = 4;
  Table[0][4].act = 's';   Table[0][4].num = 5;
  Table[1][0].act = 's';   Table[1][0].num = 6;
  Table[2][0].act = 'r';   Table[2][0].num = 2;
  Table[2][1].act = 's';   Table[2][1].num = 7;
  Table[2][3].act = 'r';   Table[2][3].num = 2;
  Table[2][5].act = 'r';   Table[2][5].num = 2;
  Table[3][0].act = 'r';   Table[3][0].num = 4;
  Table[3][1].act = 'r';   Table[3][1].num = 4;
  Table[3][3].act = 'r';   Table[3][3].num = 4;
  Table[3][5].act = 'r';   Table[3][5].num = 4;
  Table[4][2].act = 's';   Table[4][2].num = 4;
  Table[4][4].act = 's';   Table[4][4].num = 5;
  Table[5][0].act = 'r';   Table[5][0].num = 6;
  Table[5][1].act = 'r';   Table[5][1].num = 6;
  Table[5][3].act = 'r';   Table[5][3].num = 6;
  Table[5][5].act = 'r';   Table[5][5].num = 6;
  Table[6][2].act = 's';   Table[6][2].num = 4;
  Table[6][4].act = 's';   Table[6][4].num = 5;
  Table[7][2].act = 's';   Table[7][2].num = 4;
  Table[7][4].act = 's';   Table[7][4].num = 5;
  Table[8][0].act = 's';   Table[8][0].num = 6;
  Table[8][3].act = 's';   Table[8][3].num = 11;
  Table[9][0].act = 'r';   Table[9][0].num = 1;
  Table[9][1].act = 's';   Table[9][1].num = 7;
  Table[9][3].act = 'r';   Table[9][3].num = 1;
  Table[9][5].act = 'r';   Table[9][5].num = 1;
  Table[10][0].act = 'r';  Table[10][0].num = 3;
  Table[10][1].act = 'r';  Table[10][1].num = 3;
  Table[10][3].act = 'r';  Table[10][3].num = 3;
  Table[10][5].act = 'r';  Table[10][5].num = 3;
  Table[11][0].act = 'r';  Table[11][0].num = 5;
  Table[11][1].act = 'r';  Table[11][1].num = 5;
  Table[11][3].act = 'r';  Table[11][3].num = 5;
  Table[11][5].act = 'r';  Table[11][5].num = 5;
  Table[1][5].act = 'a';
  Table[0][7].num = 1;
  Table[0][8].num = 2;
  Table[0][9].num = 3;
  Table[4][7].num = 8;
  Table[4][8].num = 2;
  Table[4][9].num = 3;
  Table[6][8].num = 9;
  Table[6][9].num = 3;
  Table[7][9].num = 10;
}


void  push(int state, Node *node )
{
  sp++;
  Stck[sp].node  = node;
  Stck[sp].state = state;
}


void  pop(void)
{
  free(Stck[sp].node->str);
  free(Stck[sp].node->sym);
  free(Stck[sp].node);
  sp--;
}


BOOL  is_token(int c)  /* used in get_token() */
{
  if( isdigit( c ) || c == '|' || c == '&' ||
      c == '('     || c == ')' ) 
    return( TRUE );
  else  return( FALSE );
}


void  get_token(char *str, char *sym )
{
  int  i, l;

  l = strlen( input );
  for( i=0; i<l && !is_token( input[i] ); i++ ) ;
  sym[0] = input[i++];
  sym[1] = '\0';
  for(    ; i<l && !is_token( input[i] ); i++ ) ;
  strcpy( input, &input[i] );

  if( sym[0] == '\0' )    strcpy( str, "$" );
  else if( sym[0] == '|' )  strcpy( str, "|" );
  else if( sym[0] == '&' )  strcpy( str, "&" );
  else if( sym[0] == '(' )  strcpy( str, "(" );
  else if( sym[0] == ')' )  strcpy( str, ")" );
  else        strcpy( str, "*" );
}


int
where(char  *str )
{
  switch( str[0] ) {
      case '|': return( 0 );
      case '&': return( 1 );
      case '(': return( 2 );
      case ')': return( 3 );
      case '*': return( 4 );
      case '$': return( 5 );
      case 'S': return( 6 );
      case 'E': return( 7 );
      case 'T': return( 8 );
      case 'F': return( 9 );
  }
  return -1;
}


int
parse(void)
{
  int  i, j, k, l, criterionNumber = 0;
  char  str[MAXLINE], sym[MAXLINE];
  Node  *node;
  int  outp;

  get_token( str, sym );
  j   = where( str );
  for( i=sp=outp=0; ; ) {
    switch( Table[i][j].act ) {
      case 's':
        node = (Node *)malloc(sizeof(Node));
        l = strlen( str );
        node->str = (char *)malloc( (l+1)*sizeof(char) );
        strcpy( node->str, str );
        l = strlen( sym );
        node->sym = (char *)malloc( (l+1)*sizeof(char) );
        strcpy( node->sym, sym );
        i = Table[i][j].num;
        push( i, node );
        get_token( str, sym );
        j = where( str );
        break;
      case 'r':
        switch( Table[i][j].num ) {
          case 1: Postfix[outp++] = '|';
	    /* putchar( '|' ); putchar( '\n' ); */
            break;
          case 3: Postfix[outp++] = '&';
            /* putchar( '&' ); putchar( '\n' ); */
            break;
          case 6: Postfix[outp++] = Stck[sp].node->sym[0];
            criterionNumber ++;
            /* putchar( Stck[sp].node->sym[0] );
            ** putchar( '\n' ); */
            break;
          default:break;
        }
        node    = (Node *)malloc(sizeof(Node));
        l    = strlen( Grm[Table[i][j].num].non_term );
        node->str = (char *)malloc( (l+1)*sizeof(char) );
        strcpy( node->str, Grm[Table[i][j].num].non_term );
        node->sym = NULL;
        for( k=0; k<Grm[Table[i][j].num].len_sym; k++ )
          pop();
        i    = Stck[sp].state;
        k    = where( node->str );
        i    = Table[i][k].num;
        push( i, node );
        break;
      case 'a':  Postfix[outp] = '\0';
        return( criterionNumber );
      case 'n':  return( -1 );
    }
    continue;
  }
}

BOOL
term(void)
{
  int  ip;

  for( ip=sp=0; Postfix[ip] != '\0'; ip++ ) {
    switch( Postfix[ip] ) {
      case '|':
        Stk[0] = Stk[0] | Stk[1];
        sp = 1;
        break;
      case '&':
        Stk[0] = Stk[0] & Stk[1];
        sp = 1;
        break;
      default:
        Stk[sp++] = termCheck( Postfix[ip]-'0' );
    }
  }
  return( Stk[0] );
}


#define  NOVAL  (0)
#define  IVAL  (1)
#define  DVAL  (2)
#define  SVAL  (3)

BOOL
termCheck(int term )
{

  switch( term ) {
      case 0: return( term0() );
      case 1: return( term1() );
      case 9: return( term9() );
      case 2: case 3: case 4: case 5:
      case 6: case 7:
      default: break;
  }
  return( FALSE );
}

BOOL
term0(void)
/***********************************************
**   Number of Iteration >= criterion value   **
************************************************/
{
  static BOOL  satisfy=FALSE;

  if( Step >= criterionValue[0] ) {
    if( satisfy == FALSE ) {
      satisfy = TRUE;
      putTermMessage( 0, IVAL, Step, 0.0, NULL );
    }
    return( TRUE  );
  }
  return( FALSE );
}


BOOL
term1(void)
/******************************************
**   : Value of Error < criterion value  **
*******************************************/
{
  static BOOL  satisfy=FALSE;

  if( ErrorValue < criterionValue[1] ) {
    if( satisfy == FALSE ) {
      satisfy = TRUE;
      putTermMessage( 1, DVAL, 0, criterionValue[1], NULL );
    }
    return( TRUE  );
  }
  return( FALSE );
}


BOOL
term9(void)
/********************************************************
** Used by Simplex Method                              **
**   : Standard Deviation of Errors < criterion value  **
*********************************************************/
{
  int  i;
  double  x, ave=0.0,tmp;
  static BOOL  satisfy=FALSE;

  x = 0.0;
  for( i=0; i<NumVarParam; i++ ) ave += Err[i];

  x = 0.0;
  for( i=0; i<NumVarParam; i++ ) {
     tmp = Err[i]-ave;
    x += square( tmp );
  }
  x = sqrt( x / (double)(NumVarParam+1) );
  if( x < criterionValue[9] ) {
    if( satisfy == FALSE ) {
      satisfy = TRUE;
      putTermMessage( 9, DVAL, 0, criterionValue[9], NULL );
    }
    return( TRUE  );
  }
  return( FALSE );
}

void
getTermMessage(int id, int valType, 
	       int ival, double dval, char *sval, char *ret )
/*******************************************************************
**  id       is Item Number of Terminate Criterion.               **
**  valType  indicates which type of value to print,              **
**                   where NOVAL means not printing.              **
**  ival     is integer type value about the termination          **
**  dval     is double  type value about the termination          **
**  sval     is string  type value about the termination          **
*******************************************************************/
{
  int  i;
  char  line[80], *cp;
  FILE  *fp;

  if( (fp=fopen( TERMFILE, "r" )) == NULL ) {    /* opens ERROR.NPE */
    exit( 405 );
  }
  for( i=0; i<=id ; i++ ) {  /* finds message */
    if( fgets(line,80,fp) == NULL ) {
      exit( 41 );
    }
  }
  fclose( fp );

  cp = strtok( line, " \t\n" );  /** skips to message string  **/
  cp = strtok( NULL, "\n" );     /** is message string        **/
  strcpy( line, cp );            /** copies message to 'line' **/
  switch( valType ) {            /** adds value to message    **/
    case IVAL:  sprintf( ret, "  %s%d", line, ival );  break;
    case DVAL:  sprintf( ret, "  %s%g", line, dval );  break;
    case SVAL:  sprintf( ret, "  %s%s", line, sval );  break;
    case NOVAL:
    default:  break;
  }
}

int  MessagePointer = 0;  /* is pointer of tail of criterion message */


void
putTermMessage(int id, int valType, int ival, double dval, char *sval )
{
  char  line[80];
  Header  head;

  /******* print message to stdout ******/
  getTermMessage( id, valType, ival, dval, sval ,line);
  puts( line );
  fflush( stdout );

  /******* print message to Header of file ******/
  if(  LoadHeader( HistoryHead->fname, &head ) < 0 ){
    printf("Warrning: Can't open < %s >\n",HistoryHead->fname);
  }

  if( MessagePointer != 0 ) {
    strcpy( &head.comment[MessagePointer], "  ,  " );
    MessagePointer += 5;
  }
  strcpy( &head.comment[MessagePointer], line );
  StoreHeader( HistoryHead->fname, &head );
  MessagePointer += strlen( line );
}
