/********************************************************************
**	Header File
********************************************************************/
#define MAXGRAMMER      (7)
#define MAXSTACK        (30)

#if !defined(MAXLINE)
#define MAXLINE         (128)
#endif

#define	MAXCRITERION	(10)
#define N_STATE         (12)
#define N_TERMS         (5)
#define N_NON_T         (4)

struct Grammer {
  char	*non_term;
  char	*terms;
  int	len_sym;
};

struct Cell {
	char		act;
	int		num;
};

struct Node {
	char		*str, *sym;
};

struct Stack {
	struct Node	*node;
	int		state;
};

typedef struct Grammer	Grammer;
typedef struct Cell	Cell;
typedef struct Node	Node;
typedef struct Stack	Stack;

/* gloval vars */
Grammer Grm[MAXGRAMMER];                        /* Grammer rules      */
Stack   Stck[MAXSTACK];                         /* Stack for parse    */
char	Postfix[MAXSTACK];			/* Postfix            */
BOOL	Stk[2];					/* Stack for trans    */
Cell    Table [N_STATE][N_TERMS+N_NON_T+1];     /* Parsing table      */
char    input [MAXLINE];                        /* Input sentence     */
int	sp;					/* Stack Pointer      */
double	criterionValue[MAXCRITERION];		/* Value of Criterion */
