## NPE sample script file ( NCS model )
## contents:
##    hh.sl       This file
##    hh_com.sl   Estimation condition script
##    hh.prm      Estimation condition file
##    hh.mdl      NCS model source file
##    hh_pena.mdl Penalty file

# Setting of NCS
nasgn("hh");
npp();
nlink("-O2","O"); 
ntime(10, 0.01, 0.01, 1);
nstim("HH", 0, P, 1, 0, 100, 3, 999 );
series V;
nout(V, "HH", 0, 1);
ninteg(F);

# Generate experimental data & weight data
ncal();
series wgt;
wgt = (1~(length(V)))*0 + 1;

# Store experimental data & weight data into each file
$"hh.dat":[0] = V;
$"hh.wgt":[0] = wgt;

# Setting of NPE
unix("gcc -c -O2 hh_pena.c");  # Compile model file
npeinit();                     # Initialization of NPE

# You can chose script or file to set estimation condition.
#cload("hh.prm");     # Chose file
inline("hh_com.sl");  # Chose script
cpoint(length(V));

series res,hi;
npe(res,hi);          # Start estimation
