##
## Estimation condition script
##
## '#' means comment.
##

# Estimation method
cmethod("bfgs");            # Set optimization algorithm to "bfgs"
clsearch("golden",1.0e-04); # Set linear search algorithm to "golden"

# Model filename
cmodel("NCS","hh.o");       # Set model file to "hh.o"

# Penalty filename
cpenalty("hh_pena.o");

# Initial value of each parameters
cinit(2, 1, 140.0, "VAR", "GNa@HH", 1.0e-05); # Set "GNa" to 140.0
cinit(2, 2,   0.1, "VAR",  "Cm@HH", 1.0e-05); # Set "Cm"  to 0.1

# Scaling method
cscale(3);                  # Set scaling method to "No scaling"

# Termination condition
clogic("0|1");              # Set logical relationship between each condition
cterm(0, 100);              # Set maximum iteration numbers to 100
cterm(1, 1.0e-3);           # Set cost function value to not more than 1.0e-3

# Number of model output
cnumber(1);                 # Set output number of model to "1"

# Experimental data & weight data filenames
cdata("hh.dat");            # Set experimental data file to "hh.dat"
cweight("hh.wgt");          # Set weight data file to "hh.wgt"

# Model output & paramter history filenames
cresult("hh_res.dat");      # Set model output file to "hh_res.dat"
chistory("hh_hist.dat",10); # Set parameter history file to "hh_hist.dat"

# Integration method (F means adaptive)
cinteg("F");

## Following command sets it at need !!

# Disply method of cost function value
cdisp(0);                   # Set disply method of
                            #   cost function value to "No weight"

# Calculation method of cost function value
cnorm(2);                   # Set calculation method of
                            #   cost function value to "2-norm"
