## NPE sample script file ( USR model, 1-output )
## contents:
##    sin1.sl       This file
##    sin1_com.sl   Estimation condition script
##    sin1.prm      Estimation condition file
##    sin1.c        Model source file
##    sin1_pena.c   Penalty file

undef(dpt);undef(Amp);
undef(Phase);undef(Bias);
const dpt = 1000;
const Amp = 2;
const Phase = PI/8;
const Bias = 2;
sam(dpt);

series x,y[1],wgt[1];

# Generate experimental data(sin)
x = (0~(dpt-1))/dpt;
y[0] = Amp*sin(2*PI*x + Phase) + Bias;
$"sin1.dat" = trans(y);

# Make weight data
wgt[0] = (0~(dpt-1))*0 + 1;
$"sin1.wgt" = trans(wgt);

# Setting of NPE
unix("gcc -c -O2 sin1.c");       # Compile model file
unix("gcc -c -O2 sin1_pena.c");  # Compile penalty file
npeinit();                       # Initialization of NPE

# You can chose script or file to set estimation condition.
#cload("sin1.prm");              # Chose file
inline("sin1_com.sl");           # Chose script

series result, hi
npe(result,hi);        # Start estimation
