##
## Estimation condition script
##
## '#' means comment.
##

# Estimation method
cmethod("bfgs");             # Set optimization algorithm to "bfgs"
clsearch("golden",1.0e-04);  # Set linear search algorithm to "golden"

# Model filename
cmodel("USR","sin1.o");      # Set model file to "sin1.o"

# Penalty filename
cpenalty("sin1_pena.o");     # Set penalty file to "sin1_pena.o"

# Initial value of each parameters
cinit(3, 1, 3.0, "VAR", "Amp.",  1.0e-06); # Set "Amp"   to 3.0
cinit(3, 2, 1.0, "VAR", "Phase", 1.0e-06); # Set "Phase" to 1.0
cinit(3, 3, 1.0, "VAR", "Bias",  1.0e-06); # Set "Bias"  to 1.0

# Scaling method
cscale(0);                   # Set scaling method to "No scaling"

# Termination condition
clogic("0|1");               # Set logical relationship between each condition
cterm(0, 100);               # Set maximum iteration numbers to 100
cterm(1, 1.0e-4);            # Set cost function value to not more than 1.0e-4

# Number of model output
cnumber(1);                  # Set output number of model to  "2"

# Experimental data & weight data filenames
cpoint(1000);                # Set number of experimental data to "1000"
cdata("sin1.dat");           # Set experimental data file to "sin1.dat"
cweight("sin1.wgt");         # Set weight data file to "sin1.wgt"

# Model output & parameter history filename
cresult("sin1_res.dat");      # Set model output file to "sin1_res.dat"
chistory("sin1_hist.dat",10); # Set parameters file to "sin1_hist.dat"

## Following command sets it at need !!

# Disply method of cost function value
cdisp(0);                     # Set disply method of
                              #   cost function value to "No weight"

# Calculation method of cost function value
cnorm(2);                     # Set calculation method of
                              #   cost function value to "2-norm"
