## NPE sample script file ( USR model, 2-outputs )
## contents:
##    sin2.sl       This file
##    sin2_com.sl   Estimation condition script
##    sin2.prm      Estimation condition file
##    sin2.c        Model source file
##    sin2_pena.c   Penaly file

undef(dpt);undef(A1);undef(A2);
undef(B_);undef(C_);
const dpt = 1000;
const A1  = 2;
const A2  = 3;
const B_  = PI/8;
const C_  = 2;

series y[dpt],wgt[dpt];

# Generate experimental data(sin & cos)
t = (0~(dpt-1))/dpt;
y:[0] = A1*sin(2*PI*t + B_) + C_;
y:[1] = A2*cos(2*PI*t + B_) + C_;

# Generate random noise
ran0 = nrand(dpt,1,0,0.01);
ran1 = nrand(dpt,3,0,0.01);

# Experimental data + random noise
y:[0] = y:[0] + ran0;
y:[1] = y:[1] + ran1;

# Make weight data
wgt:[0] = (0~(dpt-1))*0 + 1;
wgt:[1] = wgt:[0];

# Store experimental data & weight data into each file
$"sin2.dat" = y;
$"sin2.wgt" = wgt;

# Setting of NPE
unix("gcc -O3 -c sin2.c");       # Compile model file
unix("gcc -c -O2 sin2_pena.c");  # Compile penalty file
npeinit();                       # Initialization of NPE

# You can chose script or file to set estimation condition.
#cload("sin2.prm");              # Chose file
inline("sin2_com.sl");           # Chose script

series result, hist
npe(result,hist);                # Start estimation
