##
## Estimation condition script
##
## '#' means comment.
##

# Estimation method
cmethod("bfgs");              # Set optimization algorithm to "bfgs"
clsearch("golden",1.0e-04);   # Set linear search algorithm to "golden"

# Model filename
cmodel("USR","sin2.o");       # Set model file to "sin2.o"

# Penalty filename
cpenalty("sin2_pena.o");      # Set penalty file to "sin2_pena.o"

# Initial value of each parameter
cinit(4, 1,  1.8, "VAR", "A1",1.0e-05); # Set "A1" to 1.8
cinit(4, 2,  2.8, "VAR", "A2",1.0e-05); # Set "A2" to 2.8
cinit(4, 3, -0.1, "VAR", "B", 1.0e-05); # Set "B"  to -0.1
cinit(4, 4,  3.0, "VAR", "C", 1.0e-05); # Set "C"  to 3.0

# Scaling method
cscale(0);                    # Set scaling method to "No scaling"

# Termination condition
clogic("0|1");                # Set logical relationship between each condition
cterm(0, 100);                # Set maximum iteration number to 100
cterm(1, 20);                 # Set cost function value to not more than 20

# Number of model output
cnumber(2);                   # Set output number of model to  "2"

# Experimental data & weight data filename
cpoint(1000);                 # Set number of experimental data to "1000"
cdata("sin2.dat");            # Set experimental data file to "sin2.dat"
cweight("sin2.wgt");          # Set weight data file to "sin2.wgt"

# Model output & parameter history filename
cresult("sin2_res.dat");      # Set model output file to "sin2_res.dat"
chistory("sin2_hist.dat",10); # Set parameter history file to "sin2_hist.dat"

## Following command sets it at need !!

# Disply method of cost function value
cdisp(0);                     # Set disply method of
                              #   cost function value to "No weight"

# Calculation method of cost function value
cnorm(2);                     # Set calculation method of
                              #   cost function value to "2-norm"
