## NPE sample script file ( USR model )
## 2-o̓f
##
## t@Cꗗ:
##    sin2.sl     ̃t@C
##    sin2_com.sl XNvg
##    sin2.prm    t@C
##    sin2.c      USRft@C(2-o̓f)
##    sin2_pena.c t@C

undef(dpt);undef(A1);undef(A2);
undef(B_);undef(C_);
const dpt = 1000;
const A1  = 2;
const A2  = 3;
const B_  = PI/8;
const C_  = 2;

series y[dpt],wgt[dpt];

# f[^̐
t = (0~(dpt-1))/dpt;
y:[0] = A1*sin(2*PI*t + B_) + C_;
y:[1] = A2*cos(2*PI*t + B_) + C_;

# d􂳂闐̐
ran0 = nrand(dpt,1,0,0.01);
ran1 = nrand(dpt,3,0,0.01);

# f[^{
y:[0] = y:[0] + ran0;
y:[1] = y:[1] + ran1;
$"sin2.dat" = y;

# d݃f[^̍쐬
wgt:[0] = (0~(dpt-1))*0 + 1;
wgt:[1] = wgt:[0];
$"sin2.wgt" = wgt;

# NPE ̐ݒ
unix("gcc -O3 -c sin2.c");      # ft@C̃RpC
unix("gcc -c -O2 sin2_pena.c"); # t@C̃RpC
npeinit();                      # NPȄ

# D݂ɍ킹Đ̐ݒ@I
#cload("sin2.prm");             # t@CpĐݒ
inline("sin2_com.sl");          # XNvgpĐݒ

series result, hist;
npe(result,hist);               # Jn
