#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "defs.h"
#include "prototype.h"
#include "y.tab.h"

typedef struct Alias {		/* alias table entry */
  char            used;
  char           *nickname;
  char           *realname;
  struct Alias   *next;
} Alias;

static Alias *a_install     _ANSI_ARGS_((char *nickname, char *realname));
static Alias *a_lookup      _ANSI_ARGS_((char *nickname));
static void   a_print       _ANSI_ARGS_((void));

static Alias  *alist = 0;	/* alias table: linked list */


static void
a_print()
{				/* find s in alias table */
  register Alias          *ap;

  for (ap = alist; ap != (Alias *) 0; ap = ap->next)
    printf("\t%s\t%s\n", ap->nickname, ap->realname);
}

void
a_clear()
{				/* find s in alias table */
  register Alias          *ap;

  for (ap = alist; ap != (Alias *) 0; ap = ap->next)
    ap->used = FALSE;
}



static Alias *
a_lookup(nickname)		/* find s in alias table */
     char  *nickname;
{
  register Alias          *ap;

  for (ap = alist; ap != (Alias *) 0; ap = ap->next) {
    if (equal(ap->nickname, nickname))
      return ap;
  }
  return 0;		/* 0 ==> not found */
}

static int
a_delete(nickname)
     char   *nickname;
{
  register Alias          *ap, *prev = (Alias *) 0;

  for (ap = alist; ap != (Alias *) 0; ap = ap->next) {
    if (equal(ap->nickname, nickname))
      break;
    prev = ap;
  }
  if (ap == (Alias *) 0)
    return 0;	/* 0 ==> not found */

  if (prev == (Alias *) 0)
    alist = ap->next;
  else
    prev->next = ap->next;
  efree(ap->nickname);
  efree(ap->realname);
  efree((char *)ap);
  return 1;		/* 1 ==> deleted */
}


static Alias *
a_install(nickname, realname)		/* install s in symbol table */
     char  *nickname, *realname;
{
  Alias          *ap;

  ap = (Alias *) emalloc(sizeof(Alias));
  ap->used = FALSE;
  ap->nickname = emalloc(strlen(nickname) + 1);	/* +1 for '\0' */
  ap->realname = emalloc(strlen(realname) + 1);	/* +1 for '\0' */
  strcpy(ap->nickname, nickname);
  strcpy(ap->realname, realname);
  ap->next = alist;	/* put at front of list */
  alist = ap;
  return ap;
}


char    *
a_replace(nickname)
     char   *nickname;
{
  Alias          *ap;
  static Alias   *bak_ap = NULL;
  char           *str;

  if ((ap = a_lookup(nickname)) == NULL) {
    bak_ap = NULL;
    return NULL;	/* not changed */
  }
  if (bak_ap != NULL && equal(bak_ap->nickname, nickname)) {
    bak_ap = NULL;
    return NULL;	/* not changed */
  }
  if (ap->used == TRUE)
    execerror(nickname, ": alias loop!!");

  ap->used = TRUE;
  str = emalloc(strlen(ap->realname) + 1);
  strcpy(str, ap->realname);
  bak_ap = ap;
  return str;
}



Object   *
alias(nargs, objs)
     int	nargs;
     Object	*objs[];
{
  char           *nick = 0, *real = 0;

  if(nargs > 2)
    execerror("alias(),", "mismatch: number of arguments");

  if(nargs > 0 && TypeofOBJ(objs[0]) == STRING_T)
    nick = ((char **)objs[0]->val)[0];
  if(nargs > 1 && TypeofOBJ(objs[1]) == STRING_T)
    real = ((char **)objs[1]->val)[0];
	
  if (nick == NULL) {	/* Print alias tables */
    /* char	*s = ""; maybe not use */
    a_print();
    return NULL;
  }

  if ( real != NULL && *real != '\0' ) {/* Append alias table */
    Alias          *ap = a_lookup(nick);
    if (ap != 0) {
      efree(ap->realname);
      ap->realname = (char *) emalloc(strlen(real) + 1);
      strcpy(ap->realname, real);
    } else {
      ap = a_install(nick, real);
    }
  } else {		/* Delete alias table */
    a_delete(nick);
  }
  return (Object *)NULL;
}

