#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "defs.h"
#include "prototype.h"
#include "y.tab.h"

Object *
WriteType(nargs, objs)
    int    nargs;
    Object *objs[];
{
  char *str, *argv[4], *write_type();
  char *format = NULL, *type = NULL;
  int   byte = 0, index;
  Object*  result ; 
  
  if (nargs == 0) {
    format = "?";
  } else if (nargs == 3) {
    if (TypeofOBJ(objs[0]) == STRING_T)
      format = ((char **) objs[0]->val)[0];
    else
      execerror("write_type(),", "illegal object type");
    
    if (TypeofOBJ(objs[1]) == STRING_T)
      type = ((char **) objs[1]->val)[0];
    else
      execerror("write_type(),", "illegal object type");
    
    if (TypeofOBJ(objs[2]) == STRING_T)
      byte = atoi(((char **) objs[2]->val)[0]);
    else if (TypeofOBJ(objs[2]) == SCALAR_T)
      byte = (int) (*(double *) objs[2]->val);
    else
      execerror("write_type(),", "illegal object type");
    
  } else
    execerror("write_type(),", "mismatch: number of arguments");
  
  str = write_type(format, type, byte);
  separate(str, argv, 4, "/");
  index = 3;

  result = newacc( (void*)argv, 1, &index, &String );

  return result ; 
}


Object  *
GarCo(nargs, objs)
     int             nargs;
     Object         *objs[];
{
  if (nargs != 0)
    execerror("GarCo()", "mismatch: number of arguments");

#if DEBUG
  fprintf(stderr, "\nGarbage collecting ... ");
#endif

  FreeSymbols();

#if DEBUG
  fprintf(stderr, "\n\tdone.\n");
#endif

  return (Object *)NULL;
}

Object  *
Symbols(nargs, objs)
     int             nargs;
     Object         *objs[];
{
  if (nargs != 0)
    execerror("Symbols()", "mismatch: number of arguments");
  listup();
  return (Object *)NULL;
}


Object *
lengthof(nargs, objs)
     int    nargs;
     Object *objs[];
{
  double d;
  int i, index[MAX_INDEX];
  
  if (nargs != 1)
    execerror("length()", "mismatch: number of arguments");
  if (objs[0] == NULL)
    execerror("length()", "illegal object");
  
  if (objs[0]->method->objtype != STRING_T) {
    if (objs[0]->method->objtype == SCALAR_T) { /* take */
      objs[0]->index = 0;
    } else {
      objs[0]->dim = (unsigned char)
      ((int)GetBufferInfo( *(int*)objs[0]->val, index ));
    objs[0]->index =
      (int*)erealloc((char*)(objs[0]->index), sizeof(int)*objs[0]->dim);
    for ( i = 0; i < objs[0]->dim; i++ )
      objs[0]->index[i] = index[i];
    }
  } /* take */
  
  d = (objs[0]->index == 0) ? 1 : (double) (objs[0]->index[0]);
  return newacc(&d, 0, NULL, &Scalar);
}


Object *
indexof(nargs, objs)
     int    nargs;
     Object *objs[];
{
  int    n;
  int    index[MAX_INDEX];
  Buffer buf[MAX_INDEX];
  
  if (nargs != 1)
    execerror("index()", "mismatch: number of arguments");
  if (objs[0] == NULL)
    execerror("index()", "illegal object");
  Bzero(buf, sizeof(buf));
  if (objs[0]->dim != 0) {
    
    if ( objs[0]->method->objtype != STRING_T ) {
      objs[0]->dim = (unsigned char)
	((int)GetBufferInfo( *(int*)objs[0]->val, index ));
      objs[0]->index =
	(int*)erealloc((char*)(objs[0]->index),sizeof(int)*(int)objs[0]->dim);
      for ( n = 0; n < objs[0]->dim; n++ )
	objs[0]->index[n] = index[n];
    } /* take */
    
    for (n = 0; n < objs[0]->dim; n++)
      buf[n] = (Buffer) (objs[0]->index[n]);
  }
  if (objs[0]->dim <= 1)
    return newacc(buf, 0, NULL, &Scalar);
  else
    return newacc(buf, 1, &n, &Series);
}


Object *
Typeof(nargs, objs)
     int    nargs;
     Object *objs[];
{
  register int    i;
  Object         *obj = objs[0];
  static char    *undefine = "undefine";
  char          **strp = &undefine;

  static struct {
    int             no;
    char           *name;
  } types[] = {
    {SCALAR_T, "scalar"},
    {STRING_T, "string"},
    {SERIES_T, "series"},
    {SNAPSHOT_T, "snapshot"},
    {CONSTANT, "constant"},
    {MODULE_NAME, "module"},
    {BUILTIN_T, "builtin"},
    {0, 0}
  };

  if (nargs != 1)
    execerror("typeof()", "mismatch: number of arguments");
  if (obj == NULL)
    execerror("typeof()", "illegal object");
  
  for (i = 0; types[i].name != 0; i++) {
    if (TypeofOBJ(obj) == types[i].no ) {
      strp = &(types[i].name);
      break;
    }
  }
  return newacc(strp, 0, NULL, &String);
}

Object *
Printf(nargs, objs)
     int    nargs;
     Object *objs[];
{
  register int	i = 0, n = 0;
  char	*p, *format, fmt[10];
  Object	*this;
  if(objs[n] == NULL || TypeofOBJ(objs[n]) != STRING_T) {
    execerror("printf()", "illegal formatter");
  }
  format = *(char **)objs[n++]->val;
  
  for(p = format; *p; i = 0, p++) {
    if(*p != '%') {
      putchar(*p);
      continue;
    }
    fmt[i++] = *p++;	/* % */
    if(*p == '-')
      fmt[i++] = *p++;
    while(isdigit(*p) || *p == '.')
      fmt[i++] = *p++;
    switch(*p){
    case 'l':
      fmt[i++] = *p++; /* break through*/
    case 'e' or 'f' or 'g' or 'd' or 's' or 'c':
      fmt[i++] = *p;
      fmt[i] = '\0';
      break;
    default:
      putchar(*p);
      continue;
    }
    
    this = objs[n++];
    if(this == NULL) {
      char	mes[20];
      sprintf(mes, "illegal %dth object", n);
      execerror("printf()", mes);
    }
    (* this->method->print)(fmt, this, 0);  
  }
  return (Object *)NULL;
}

Object *
Abort(nargs, objs)
     int    nargs;
     Object *objs[];
{
  intcatch();

#if 0 /* nouse */
  {
    char	 *s;
    Object *obj = objs[0];
  
    if (obj == NULL || TypeofOBJ(obj) != STRING_T)
      execerror("ABORT", "by user");
    
    s = *(char **)obj->val;
    execerror("ABORT", s);
  }
#endif /* nouse */

  return NULL;
}
