#include  <stdio.h>
#include  <string.h>
#include  <ctype.h>
#include  "defs.h"
#include  "prototype.h"
#include  "y.tab.h"

Object *
Strlen(narg, objs)
     int      narg;
     Object  *objs[];
{
  int             n;
  char          **argv;
  double          d;
  if (narg != 1)
    execerror("strlen(),", "mismatch:  number of arguments");

  if (TypeofOBJ(objs[0]) != STRING_T)
    execerror("strlen(),", "illegal object type (not string)");

  n = IndexSize(objs[0]->dim, objs[0]->index);
  argv = (char **) objs[0]->val;
  if (n == 1) {
    d = (double) strlen(argv[0]);
    return newacc(&d, 0, NULL, &Scalar);
  } else {
    register int    i;
    Object         *acc;
    Buffer         *buf = AllocBuffer(n);
    for (i = 0; i < n; i++)
      buf[i] = (double) strlen(argv[i]);
    acc = newacc(buf, objs[0]->dim, objs[0]->index, &Series);
    FreeBuffer(buf);
    return acc;
  }
}
