#include <stdio.h>
#include "defs.h"
#include "prototype.h"
#include "y.tab.h"

#define WELCOME		"Welcome to The SATELLITE World"
#define COPYRIGHT	"BPEL, Toyohashi University of Technology"
#define YEAR		"1992 - 2002"
#define VERSION		SL_VERSION


static void
symbols(sym, n)
     char	*sym;
     int	n;
{
  register int	i;
  int	len = strlen(sym);
  if(len == 0)
    return;
  n /= len;
  for(i = 0; i < n && i < 256; i++)
    printf("%s", sym);
}


Object  *
welcome(nargs, objs)
     int             nargs;
     Object         *objs[];
{
  int	LINES, COLUMNS;
  static  char asta[2] = {"*"};
  char	sbuf[256], *sym = asta;
  Object	*obj = objs[0];

  if(nargs != 0)  {
    if(obj == NULL || TypeofOBJ(obj) != STRING_T)
      execerror("welcome()", "illegal object");
    sym = ((char **)obj->val)[0];
  }

  GetSize(&LINES, &COLUMNS);	

  if ( LINES > 0 && COLUMNS > 0 ) {
    symbols(sym, COLUMNS);
    symbols(" ", (COLUMNS - strlen(WELCOME))/2);	
    puts(WELCOME);

    sprintf(sbuf, "Copyright (C) %s, %s", YEAR, COPYRIGHT);
    symbols(" ", (COLUMNS - strlen(sbuf))/2);	
    puts(sbuf);

    sprintf(sbuf, "Version %s", VERSION);
    symbols(" ", (COLUMNS - strlen(sbuf))/2);	
    puts(sbuf);
	
    symbols(sym, COLUMNS);
    puts("\n");
    fflush(stdout);
  }
  return (Object *)NULL;
}


Object  *
goodbye(nargs, objs)
     int             nargs;
     Object         *objs[];
{
  int	LINES, COLUMNS;
  GetSize(&LINES, &COLUMNS);	
  if ( LINES > 0 && COLUMNS > 0 ) {
    fprintf(stderr, "\n\tExit The SATELLITE World      ... Thank you.\n");
  }
  return (Object *)NULL;
}
