/**********************************************************************
	code.c :  Part of Stack Machine Code

			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/
#include <stdio.h>
#include <string.h>

#include "defs.h"
#include "prototype.h"
#include "y.tab.h"
#include "code.h"

/**********************************************************************
  STACK MACHINE   CODE  : Stack Operation Code
  ***********************************************************************/


void
snapshot()
{				/* evaluate variable on stack */
  Object  *obj;
  Datum    var, d;
  int      time;

  var = pop();			/* pop variable name (in symbolic table) */
  if (var.sym->type == UNDEF)
    execerror("undefined variable", var.sym->name);

  d = pop_obj();		/* pop time index */
  if (d.obj == NULL || TypeofOBJ(d.obj) != SCALAR_T)
    execerror("illegal index", var.sym->name);

  obj = getobj(var.sym);
  if (obj == NULL)
    execerror("NULL object", var.sym->name);
  if (obj->method->snap == NULL)
    execerror("not supported method with", var.sym->name);
  time = (int) (*(double *) d.obj->val);
  d.obj = (*obj->method->snap) (obj, time);
  push_obj(d);
}


void
array()
{				/* evaluate variable on stack */
  register int    i;
  int             dim = *(int *)pc++;
  int             index[MAX_INDEX];
  Datum           var, d;
  Object		*obj;

  var = pop();			/* pop variable name (in symbolic table) */
  if (var.sym->type == UNDEF)
    execerror("undefined variable", var.sym->name);

  /* pop index number */
  for (i = dim; i > 0; i--) {
    d = pop_obj();
    if (d.obj == NULL || TypeofOBJ(d.obj) != SCALAR_T)
      execerror("illegal index", var.sym->name);
    index[i - 1] = (int) (*(double *) d.obj->val);
  }

  obj = getobj(var.sym);
  if (obj == NULL)
    execerror("NULL object", var.sym->name);
  if (obj->method->array == NULL)
    execerror("not supported method with", var.sym->name);

  d.obj = (*obj->method->array) (obj, dim, index);
  push_obj(d);
}


void
array_asgn()
{
  register int    i;
  int             dim = *(int *)pc++;
  int             index[MAX_INDEX];
  Datum           var, d, val;
  Object         *x, *y;


  var = pop();			/* symbol table of pop variable name */
  if (var.sym->type != VAR)
    execerror("undefined variable", var.sym->name);

  /* pop assignment value */
  val = pop_obj();

  /* pop index number */
  for (i = dim; i > 0; i--) {
    d = pop_obj();
    if (d.obj == NULL || TypeofOBJ(d.obj) != SCALAR_T)
      execerror("illegal index", var.sym->name);
    index[i - 1] = (int) (*(double *) d.obj->val);
  }

  x = getobj(var.sym);
  if ((y = val.obj) == NULL)
    execerror("null object assignment", var.sym->name);

#if 0
  if (x != NULL && TypeofOBJ(x) != TypeofOBJ(y)) {
    char s[100];
    sprintf(s, "WARNING ... illegal combination of %s and right", var.sym->name);
    warning(s, 0);
  }
#endif

  if (x->method->array_asgn == NULL)
    execerror("not supported method", var.sym->name);
  (*x->method->array_asgn) (x, dim, index, y);
  push_obj(val);
}

void
snapshot_asgn()
{
  Object		*obj;
  Datum           d, val, var;
  int             time;

  var = pop();			/* pop varable */
  if (var.sym->type == UNDEF)
    execerror("undefined variable", var.sym->name);

  val = pop_obj();		/* pop value */
  d = pop_obj();		/* pop time index */
  if (TypeofOBJ(d.obj) != SCALAR_T)
    execerror("illegal index,", var.sym->name);
  time = (int) (*(double *) d.obj->val);

  obj = getobj(var.sym);
  if (obj->method->snap_asgn == NULL)
    execerror("not supported method", var.sym->name);
  (*obj->method->snap_asgn) (obj, time, val.obj);
  push_obj(val);
}



void
new()
{
  register int  j, k;
  Symbol *      class = (Symbol *) *pc++;
  Symbol *      var   = (Symbol *) *pc++; 
  int           dim = *(int *)pc++;
  int	        n = dim;
  int           w, siz;
  int		index[MAX_INDEX];
  char          *area;
  Object        *obj;
  Datum         tmp;

  Bzero(index, MAX_INDEX);
  if(class->type == SCALAR_T && dim != 0)
    execerror("scalar: illegal dimension", var->name);
  if(class->type == SERIES_T) {
    dim++;
    if ( dim > MAX_INDEX ) 
      execerror("series: illegal dimension", var->name);
    index[0] = 1;	
  }
  if(class->type == SNAPSHOT_T && ( dim == 0 || dim > MAX_INDEX))
    execerror("snapshot: illegal dimension", var->name);

  k = dim - 1;
  for (j = 0; j < n; j++) {
    tmp = pop_obj();
    if (TypeofOBJ(tmp.obj) != SCALAR_T)
      execerror("illegal index with", var->name);
    if ((w = *(double *) tmp.obj->val) < 1)
      execerror("illegal index with", var->name);
    index[k--] = (int) w;
  }
  obj = getobj(var);
  if (obj != NULL) {
    if (TypeofOBJ(obj) != class->type) /* class symbol */
      warning("WARNING ... different type object", var->name);
    (* obj->method->destroy)(obj);	
  }

  siz = ((dim == 0) ? 1 : IndexSize(dim, index)) * sizeof(double);
  area = (char *) emalloc(siz);
  Bzero(area, siz);
  setobj(var, (*class->obj->method->new) ());
  (*class->obj->method->setvalue) (getobj(var), area, dim, index);
  var->type = VAR;
  efree(area); 
}

/**********************************************************************
	END OF STACK MACHINE CODE
***********************************************************************/

