/**********************************************************************
	code.bltin.c : Part of Stack Machine Code
			(built-in Parts)

			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/

#include <stdio.h>
#include <string.h>

#include "defs.h"
#include "prototype.h"
#include "code.h"
#include "y.tab.h"


#define MAXARG 5

void
basic1()
{
  static Object  *argm[2] = {0, 0};
  Datum           d1;
  d1 = pop_obj();
  argm[0] = d1.obj;
  if (d1.obj == NULL)
    execerror("null object operation", 0);
  d1.obj = (*d1.obj->method->opcode) (pc++, "basic operator", argm);
  push_obj(d1);
}

void
basic2()
{
  static Object  *argm[3] = {0, 0, 0};
  Datum           d2;
  Datum           d1;

  d2 = pop_obj();
  d1 = pop_obj();

  argm[0] = d1.obj;
  argm[1] = d2.obj;
  if (d1.obj == NULL)
    execerror("null object operation", 0);
  d1.obj = (*d1.obj->method->opcode) (pc++, "basic operator", argm);
  push_obj(d1);
}

void
dispatch()
{				/* evaluate built-in on top of stack */
  Datum           d;
  Object         *argm[MAXARG];
  Symbol         *sp = (Symbol *) * pc++;
  int             i, narg = *(int *)pc++;
  Object         *(*opcode) ();

  Bzero(argm, MAXARG * sizeof(Object *));
  if (narg == 0) {
    extern Object   Builtin;
    opcode = Builtin.method->opcode;
  } else {
    for (i = narg; i > 0; i--) {
      d = pop_obj();
      if (i < MAXARG)
	argm[i - 1] = d.obj;
    }
    if (d.obj == NULL)
      execerror("NULL object operation.", 0);
    opcode = d.obj->method->opcode;
  }

  /* sp->obj->val is function pointer    */
  /* sp->name     is function name       */
  /* argm		is function arguments  */

  d.obj = (*opcode) (sp->obj->val, sp->name, argm);
  push_obj(d);
}

void
bltin()
{				/* evaluate built-in on top of stack */
  Datum           d;
  Object         **argm;
  Symbol         *sp = (Symbol *) * pc++;
  int             i, narg = *(int *)pc++;
  Object         *(*opcode) ();

  argm = (Object **)ecalloc(narg + 1, sizeof(Object *));
  for (i = narg; i > 0; i--) {
    d = pop_obj();
    argm[i - 1] = d.obj;
  }
  opcode = *(OFUNC *) sp->obj->val;
  d.obj = (*opcode) (narg, argm);
  push_obj(d);
}

/**********************************************************************
	End of Stack Machine Code
***********************************************************************/
