/**********************************************************************
  code.c :  Part of Stack Machine Code
  
  Coded by Shigeru Hitomi  May. 4, 1992
  ***********************************************************************/
#include <stdio.h>
#include "defs.h"
#include "prototype.h"
#include "y.tab.h"
#include "code.h"

typedef struct branch {
  unsigned char   pos;
  Buffer         *buf;
  int             siz;
}               branch;

/**********************************************************************
  STACK MACHINE   CODE  : Stack Operation Code
  ***********************************************************************/

static double 
popval()
{
  Datum           d;
  d = pop_obj();
  if (d.obj == NULL)
    execerror("illegal members in series", NULL);
  if (TypeofOBJ(d.obj) != SCALAR_T)
    execerror("illegal members in series", NULL);
  return *(double *) d.obj->val;
}


void
ramp()
{
  register int    i;
  Datum           d;
  int             dim = 1, index[MAX_INDEX], dpt;
  int             from, to;
  Buffer         *buf;

  to =   (int) popval();
  from = (int) popval();

  index[0] = dpt = Max(to, from) - Min(to, from) + 1;
  buf = (Buffer *) AllocBuffer(dpt);
  if (buf == NULL)
    execerror("out of memory for internal buffer", 0);


  if (from <= to) {
    for (i = 0; i < dpt; i++)
      buf[i] = from + (Buffer) i;
  } else {
    for (i = 0; i < dpt; i++)
      buf[i] = from - (Buffer) i;
  }

  d.obj = newacc(buf, dim, index, &Series);
  FreeBuffer(buf);
  push_obj(d);
}

static void
reverse(br, n)
     branch          br[];
     int             n;
{
  int             i, m, half = n / 2;
  branch          tmp;

  for (i = 0; i < half; i++) {
    tmp.pos = br[i].pos;
    tmp.buf = br[i].buf;
    tmp.siz = br[i].siz;

    m = n - i - 1;
    br[i].pos = br[m].pos;
    br[i].buf = br[m].buf;
    br[i].siz = br[m].siz;

    br[m].pos = tmp.pos;
    br[m].buf = tmp.buf;
    br[m].siz = tmp.siz;
  }
}


static int
total_size(narg, br, n)
     int             narg, n;
     branch          br[];
{
  int             i, length = narg;

  for (i = 0; i < n; i++)
    length += br[i].siz;
  length -= n;
  return length;
}


static Buffer *
chain(org, narg, br, length)
     Buffer         *org;
     int             narg, length;
     branch          br[];
{
  int             i, j, k, p;
  Buffer         *buf = AllocBuffer(length);
  if (buf == NULL)
    execerror("out of memory for internal buffer", 0);

  p = k = 0;
  for (i = 0; i < narg; i++) {
    if (i == br[k].pos) {
      for (j = 0; j < br[k].siz; j++)
	buf[p++] = br[k].buf[j];
      k++;
    } else
      buf[p++] = org[i];
  }

  if (p != length)
    execerror("chain()", "total length missmatch");
  return buf;
}



#define	NSR	20		/* number of series in series */

void
combin()
{
  register int    i, pos;
  Datum           d;
  int             index[1], n = 0;
  int             index2[MAX_INDEX], dim2 = 1, buf_no;
  int             narg = *(int *)pc++;
  Buffer         *buf;
  branch          br[NSR];

  if (narg == 0) {		/* NULL object */
    d.obj = (Object *) NULL;
    push(d);
    return;
  }
  buf = (Buffer *) AllocBuffer(narg);
  for (i = 0; i < narg; i++) {
    d = pop_obj();
    if (d.obj == NULL)
      execerror("NULL object in series", NULL);

    pos = narg - i - 1;
    switch (TypeofOBJ(d.obj)) {
    case SERIES_T:
      if (n >= NSR - 1)		/* for mark of end */
	execerror("too many series in series", "");
      buf_no = *(int *) d.obj->val;
      br[n].pos = (unsigned char) pos;
      br[n].buf = ReadBuffer(buf_no, &dim2, index2);
      if (br[n].buf == NULL)
	execerror("failed to evaluate series", "");
      br[n].siz = IndexSize(dim2, index2);
      n++;
      if (dim2 != 1)
	execerror("combin :", "not supported dimension");
      break;
    case SCALAR_T:
      buf[pos] = *(Buffer *) d.obj->val;
      break;
    default:
      execerror("illegal members in series", NULL);
    }
  }

  if (n == 0) {
    index[0] = narg;
  } else {
    Buffer         *org = buf;
    br[n].buf = NULL;		/* mark of end */
    br[n].siz = br[n].pos = -1;	/* mark of end */
    reverse(br, n);
    index[0] = total_size(narg, br, n);
    buf = chain(org, narg, br, index[0]);
    FreeBuffer(org);
  }

  d.obj = newacc(buf,		/* dim= */ 1, index, &Series);
  FreeBuffer(buf);
  push_obj(d);
}
/**********************************************************************
  STACK MACHINE   CODE  : Stack Operation Code
  ***********************************************************************/
